/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class GenerateKeyStoreMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Boolean verbose;
    protected boolean useEnvironmentRelativeExecutables;
    protected boolean overwriteKeyStore;
    protected File keyStore;
    protected String keyStoreAlias;
    protected String keyStorePassword;
    protected String keyPassword;
    protected String certDomain;
    protected String certOrgUnit;
    protected String certOrg;
    protected String certState;
    protected String certCountry;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.keyStore.exists()) {
            if (this.overwriteKeyStore) {
                if (!this.keyStore.delete()) {
                    throw new MojoFailureException("Unable to delete existing keystore at: " + this.keyStore);
                }
            } else {
                throw new MojoExecutionException("Keystore already exists (set 'overwriteKeyStore' to force) at: " + this.keyStore);
            }
        }
        this.checkKeystoreRequiredParameter(this.keyStoreAlias, "keyStoreAlias");
        this.checkKeystoreRequiredParameter(this.keyStorePassword, "keyStorePassword");
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
        ArrayList<String> distinguishedNameParts = new ArrayList<String>();
        Organization projectOrganization = this.project.getOrganization();
        this.checkAndAddRequiredField(distinguishedNameParts, "certDomain", this.certDomain, "cn", () -> {
            if (projectOrganization != null && !StringUtils.isEmpty((String)projectOrganization.getUrl())) {
                String url = projectOrganization.getUrl();
                if (url.startsWith("http://")) {
                    return url.substring("http://".length());
                }
                if (url.startsWith("https://")) {
                    return url.substring("https://".length());
                }
            }
            return null;
        });
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrgUnit", this.certOrgUnit, "ou", () -> "none");
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrg", this.certOrg, "o", () -> {
            if (projectOrganization != null && !StringUtils.isEmpty((String)projectOrganization.getName())) {
                return projectOrganization.getName();
            }
            return null;
        });
        this.checkAndAddRequiredField(distinguishedNameParts, "certState", this.certState, "st");
        this.checkAndAddRequiredField(distinguishedNameParts, "certCountry", this.certCountry, "c");
        this.generateKeyStore(this.keyStore, this.keyStoreAlias, this.keyStorePassword, this.keyPassword, String.join((CharSequence)", ", distinguishedNameParts));
    }

    protected void generateKeyStore(File keyStore, String keyStoreAlias, String keyStorePassword, String keyPassword, String distinguishedName) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating keystore in: " + keyStore));
        try {
            Files.createDirectories(keyStore.getParentFile().toPath(), new FileAttribute[0]);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.getEnvironmentRelativeExecutablePath() + "keytool");
            command.add("-genkeypair");
            command.add("-keystore");
            command.add(keyStore.getPath());
            command.add("-alias");
            command.add(keyStoreAlias);
            command.add("-storepass");
            command.add(keyStorePassword);
            command.add("-keypass");
            command.add(keyPassword);
            command.add("-dname");
            command.add(distinguishedName);
            command.add("-sigalg");
            command.add("SHA256withRSA");
            command.add("-validity");
            command.add("100");
            command.add("-keyalg");
            command.add("RSA");
            command.add("-keysize");
            command.add("2048");
            if (this.verbose.booleanValue()) {
                command.add("-v");
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]).inheritIO().command(command);
            Process p = pb.start();
            p.waitFor();
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("There was an exception while generating keystore.", ex);
        }
    }

    private void checkKeystoreRequiredParameter(String value, String valueName) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)value)) {
            throw new MojoExecutionException("The property '" + valueName + "' is required to generate a new KeyStore.");
        }
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName) throws MojoExecutionException {
        this.checkAndAddRequiredField(distinguishedNameParts, propertyName, value, fieldName, null);
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName, RequiredFieldAlternativeCallback alternative) throws MojoExecutionException {
        if (!StringUtils.isEmpty((String)value)) {
            distinguishedNameParts.add(fieldName + "=" + value);
        } else {
            if (alternative == null || StringUtils.isEmpty((String)alternative.getValue())) {
                throw new MojoExecutionException("The property '" + propertyName + "' must be provided to generate a new certificate.");
            }
            distinguishedNameParts.add(fieldName + "=" + alternative.getValue());
        }
    }

    protected String getEnvironmentRelativeExecutablePath() {
        if (this.useEnvironmentRelativeExecutables) {
            return "";
        }
        String jrePath = System.getProperty("java.home");
        String jdkPath = jrePath + File.separator + ".." + File.separator + "bin" + File.separator;
        return jdkPath;
    }

    @FunctionalInterface
    private static interface RequiredFieldAlternativeCallback {
        public String getValue();
    }
}

