/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class GenerateKeyStoreMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenSession session;
    protected BuildPluginManager pluginManager;
    protected boolean overwriteKeyStore;
    protected File keyStore;
    protected String keyStoreAlias;
    protected String keyStorePassword;
    protected String keyPassword;
    protected String certDomain;
    protected String certOrgUnit;
    protected String certOrg;
    protected String certState;
    protected String certCountry;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.keyStore.exists()) {
            if (this.overwriteKeyStore) {
                if (!this.keyStore.delete()) {
                    throw new MojoFailureException("Unable to delete existing keystore at: " + this.keyStore);
                }
            } else {
                throw new MojoExecutionException("Keystore already exists (set 'overwriteKeyStore' to force) at: " + this.keyStore);
            }
        }
        this.checkKeystoreRequiredParameter(this.keyStoreAlias, "keyStoreAlias");
        this.checkKeystoreRequiredParameter(this.keyStorePassword, "keyStorePassword");
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
        ArrayList<String> distinguishedNameParts = new ArrayList<String>();
        Organization projectOrganization = this.project.getOrganization();
        this.checkAndAddRequiredField(distinguishedNameParts, "certDomain", this.certDomain, "cn", () -> {
            if (projectOrganization != null && !StringUtils.isEmpty((String)projectOrganization.getUrl())) {
                String url = projectOrganization.getUrl();
                if (url.startsWith("http://")) {
                    return url.substring("http://".length());
                }
                if (url.startsWith("https://")) {
                    return url.substring("https://".length());
                }
            }
            return null;
        });
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrgUnit", this.certOrgUnit, "ou", () -> "none");
        this.checkAndAddRequiredField(distinguishedNameParts, "certOrg", this.certOrg, "o", () -> {
            if (projectOrganization != null && !StringUtils.isEmpty((String)projectOrganization.getName())) {
                return projectOrganization.getName();
            }
            return null;
        });
        this.checkAndAddRequiredField(distinguishedNameParts, "certState", this.certState, "st");
        this.checkAndAddRequiredField(distinguishedNameParts, "certCountry", this.certCountry, "c");
        this.generateKeyStore(this.keyStore, this.keyStoreAlias, this.keyStorePassword, this.keyPassword, String.join((CharSequence)", ", distinguishedNameParts));
    }

    protected void generateKeyStore(File keyStore, String keyStoreAlias, String keyStorePassword, String keyPassword, String distinguishedName) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating keystore in: " + keyStore));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"keytool-maven-plugin"), (String)MojoExecutor.version((String)"1.5")), (String)MojoExecutor.goal((String)"generateKeyPair"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"keystore"), (String)keyStore.getPath()), MojoExecutor.element((String)MojoExecutor.name((String)"alias"), (String)keyStoreAlias), MojoExecutor.element((String)MojoExecutor.name((String)"storepass"), (String)keyStorePassword), MojoExecutor.element((String)MojoExecutor.name((String)"keypass"), (String)keyPassword), MojoExecutor.element((String)MojoExecutor.name((String)"dname"), (String)distinguishedName), MojoExecutor.element((String)MojoExecutor.name((String)"sigalg"), (String)"SHA256withRSA"), MojoExecutor.element((String)MojoExecutor.name((String)"ext"), (String)""), MojoExecutor.element((String)MojoExecutor.name((String)"validity"), (String)"100"), MojoExecutor.element((String)MojoExecutor.name((String)"keyalg"), (String)"RSA"), MojoExecutor.element((String)MojoExecutor.name((String)"keysize"), (String)"2048")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void checkKeystoreRequiredParameter(String value, String valueName) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)value)) {
            throw new MojoExecutionException("The property '" + valueName + "' is required to generate a new KeyStore.");
        }
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName) throws MojoExecutionException {
        this.checkAndAddRequiredField(distinguishedNameParts, propertyName, value, fieldName, null);
    }

    private void checkAndAddRequiredField(List<String> distinguishedNameParts, String propertyName, String value, String fieldName, RequiredFieldAlternativeCallback alternative) throws MojoExecutionException {
        if (!StringUtils.isEmpty((String)value)) {
            distinguishedNameParts.add(fieldName + "=" + value);
        } else {
            if (alternative == null || StringUtils.isEmpty((String)alternative.getValue())) {
                throw new MojoExecutionException("The property '" + propertyName + "' must be provided to generate a new certificate.");
            }
            distinguishedNameParts.add(fieldName + "=" + alternative.getValue());
        }
    }

    @FunctionalInterface
    private static interface RequiredFieldAlternativeCallback {
        public String getValue();
    }
}

