/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Log;
import com.sun.javafx.tools.packager.PackagerLib;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractJfxToolsMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Boolean verbose;
    protected String mainClass;
    protected File jfxAppOutputDir;
    protected String jfxMainAppJarName;
    protected String deployDir;
    private PackagerLib packagerLib;

    public PackagerLib getPackagerLib() throws MojoExecutionException {
        if (this.packagerLib == null) {
            if (this.deployDir != null) {
                this.getLog().info((CharSequence)("Adding 'deploy' directory to Mojo classpath: " + this.deployDir));
                URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                try {
                    Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)sysloader, new File(this.deployDir).toURI().toURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new MojoExecutionException("Error, could not add URL to system classloader");
                }
            }
            Log.Logger logger = new Log.Logger(this.verbose.booleanValue());
            Log.setLogger((Log.Logger)logger);
            this.packagerLib = new PackagerLib();
        }
        return this.packagerLib;
    }

    protected boolean isJavaVersion(int oracleJavaVersion) {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.startsWith("1." + oracleJavaVersion);
    }

    protected boolean isAtLeastOracleJavaUpdateVersion(int updateNumber) {
        String javaVersion = System.getProperty("java.version");
        String[] javaVersionSplitted = javaVersion.split("_");
        if (javaVersionSplitted.length <= 1) {
            return false;
        }
        return Integer.parseInt(javaVersionSplitted[1], 10) >= updateNumber;
    }
}

