/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class GenerateKeyStoreMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenSession session;
    protected BuildPluginManager pluginManager;
    protected boolean overwriteKeyStore;
    protected File keyStore;
    protected String keyStoreAlias;
    protected String keyStorePassword;
    protected String keyPassword;
    protected String certDomain;
    protected String certOrgUnit;
    protected String certOrg;
    protected String certState;
    protected String certCountry;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.keyStore.exists()) {
            if (this.overwriteKeyStore) {
                if (!this.keyStore.delete()) {
                    throw new MojoFailureException("Unable to delete existing keystore at: " + this.keyStore);
                }
            } else {
                throw new MojoExecutionException("Keystore already exists (set 'overwriteKeyStore' to force) at: " + this.keyStore);
            }
        }
        if (StringUtils.isEmpty((String)this.keyStoreAlias)) {
            throw new MojoExecutionException("A 'keyStoreAlias' is required to generate a new KeyStore");
        }
        if (StringUtils.isEmpty((String)this.keyStorePassword)) {
            throw new MojoExecutionException("A 'keyStorePassword' is required to generate a new KeyStore");
        }
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
        StringBuilder domainName = new StringBuilder();
        if (this.certDomain != null) {
            domainName.append("cn=").append(this.certDomain);
        } else if (this.project.getOrganization() != null && this.project.getOrganization().getUrl() != null) {
            String url = this.project.getOrganization().getUrl();
            if (url.startsWith("http://")) {
                url = url.substring("http://".length());
            }
            domainName.append("cn=").append(url);
        } else {
            throw new MojoExecutionException("A 'certDomain' must be provided to generate a KeyStore");
        }
        domainName.append("ou=").append(this.certOrgUnit != null ? this.certOrgUnit : "none");
        if (this.certOrg != null) {
            domainName.append("o=").append(this.certOrg);
        } else if (this.project.getOrganization() != null && this.project.getOrganization().getName() != null) {
            domainName.append("o=").append(this.project.getOrganization().getName());
        } else {
            throw new MojoExecutionException("A 'certOrg' must be provided to generate a KeyStore");
        }
        if (this.certState == null) {
            throw new MojoExecutionException("A 'certState' must be provided to generate a KeyStore");
        }
        domainName.append("st=").append(this.certState);
        if (this.certCountry == null) {
            throw new MojoExecutionException("A 'certCountry' must be provided to generate a KeyStore");
        }
        domainName.append("c=").append(this.certState);
        this.generateKeyStore(this.keyStore, this.keyStoreAlias, this.keyStorePassword, this.keyPassword, domainName.toString());
    }

    protected void generateKeyStore(File keyStore, String keyStoreAlias, String keyStorePassword, String keyPassword, String domainName) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating keystore in: " + keyStore));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"keytool-maven-plugin"), (String)MojoExecutor.version((String)"1.2")), (String)MojoExecutor.goal((String)"generateKeyPair"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"keystore"), (String)keyStore.getPath()), MojoExecutor.element((String)MojoExecutor.name((String)"alias"), (String)keyStoreAlias), MojoExecutor.element((String)MojoExecutor.name((String)"storepass"), (String)keyStorePassword), MojoExecutor.element((String)MojoExecutor.name((String)"keypass"), (String)keyPassword), MojoExecutor.element((String)MojoExecutor.name((String)"dname"), (String)domainName), MojoExecutor.element((String)MojoExecutor.name((String)"sigalg"), (String)"SHA1withDSA"), MojoExecutor.element((String)MojoExecutor.name((String)"ext"), (String)""), MojoExecutor.element((String)MojoExecutor.name((String)"validity"), (String)"100"), MojoExecutor.element((String)MojoExecutor.name((String)"keyalg"), (String)"DSA"), MojoExecutor.element((String)MojoExecutor.name((String)"keysize"), (String)"1024")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }
}

