/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NativeMojo
extends AbstractJfxToolsMojo {
    protected String identifier;
    protected String vendor;
    protected File nativeOutputDir;
    private String bundleType;
    private Map<String, String> jvmProperties;
    private List<String> jvmArgs;
    private Map<String, String> userJvmArgs;
    private String nativeReleaseVersion;
    protected boolean needShortcut;
    protected boolean needMenu;
    protected String preLoader;
    protected Map<String, String> bundleArguments;
    protected String appName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("NONE".equals(this.bundleType)) {
            return;
        }
        this.getLog().info((CharSequence)"Building Native Installers");
        try {
            Build build = this.project.getBuild();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(StandardBundlerParam.VERBOSE.getID(), this.verbose);
            if (this.identifier != null) {
                params.put(StandardBundlerParam.IDENTIFIER.getID(), this.identifier);
            }
            params.put(StandardBundlerParam.APP_NAME.getID(), this.appName);
            params.put(StandardBundlerParam.VERSION.getID(), this.nativeReleaseVersion);
            params.put(StandardBundlerParam.VENDOR.getID(), this.vendor);
            params.put(StandardBundlerParam.SHORTCUT_HINT.getID(), this.needShortcut);
            params.put(StandardBundlerParam.MENU_HINT.getID(), this.needMenu);
            params.put(StandardBundlerParam.MAIN_CLASS.getID(), this.mainClass);
            if (this.jvmProperties != null) {
                HashMap<String, String> jvmProps = new HashMap<String, String>();
                for (String key : this.jvmProperties.keySet()) {
                    jvmProps.put(key, this.jvmProperties.get(key));
                }
                params.put(StandardBundlerParam.JVM_PROPERTIES.getID(), jvmProps);
            }
            if (this.jvmArgs != null) {
                ArrayList<String> jvmOptions = new ArrayList<String>();
                for (String arg : this.jvmArgs) {
                    jvmOptions.add(arg);
                }
                params.put(StandardBundlerParam.JVM_OPTIONS.getID(), jvmOptions);
            }
            if (this.userJvmArgs != null) {
                HashMap<String, String> userJvmOptions = new HashMap<String, String>();
                for (String key : this.jvmProperties.keySet()) {
                    userJvmOptions.put(key, this.jvmProperties.get(key));
                }
                params.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), userJvmOptions);
            }
            HashSet<File> resourceFiles = new HashSet<File>();
            resourceFiles.add(new File(this.jfxAppOutputDir, this.jfxMainAppJarName));
            File libDir = new File(this.jfxAppOutputDir, "lib");
            if (libDir.exists() && libDir.list().length > 0) {
                try {
                    Files.walk(libDir.toPath(), new FileVisitOption[0]).forEach(p -> {
                        File f = p.toFile();
                        System.out.println(p.toFile());
                        if (f.isFile()) {
                            resourceFiles.add(p.toFile());
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(this.jfxAppOutputDir, resourceFiles));
            HashSet duplicateKeys = new HashSet(params.keySet());
            duplicateKeys.retainAll(this.bundleArguments.keySet());
            if (!duplicateKeys.isEmpty()) {
                throw new MojoExecutionException("The following keys in <bundleArguments> duplicate other settings, please remove one or the other: " + ((Object)duplicateKeys).toString());
            }
            params.putAll(this.bundleArguments);
            Bundlers bundlers = Bundlers.createBundlersInstance();
            for (Bundler b : bundlers.getBundlers()) {
                HashMap localParams = new HashMap(params);
                try {
                    if (this.bundleType != null && !"ALL".equals(this.bundleType) && !b.getBundleType().equals(this.bundleType)) {
                        return;
                    }
                    if (!b.validate(params)) continue;
                    b.execute(params, this.nativeOutputDir);
                }
                catch (UnsupportedPlatformException e) {
                }
                catch (ConfigException e) {
                    this.getLog().info((CharSequence)("Skipping " + b.getName() + " because of configuration error " + e.getMessage() + "\nAdvice to Fix: " + e.getAdvice()));
                }
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)e);
        }
    }
}

