/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JarMojo
extends AbstractJfxToolsMojo {
    protected boolean css2bin;
    protected String preLoader;
    protected boolean updateExistingJar;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Building JavaFX JAR for application");
        Build build = this.project.getBuild();
        CreateJarParams createJarParams = new CreateJarParams();
        createJarParams.setOutdir(this.jfxAppOutputDir);
        createJarParams.setOutfile(this.jfxMainAppJarName);
        createJarParams.setApplicationClass(this.mainClass);
        createJarParams.setCss2bin(this.css2bin);
        createJarParams.setPreloader(this.preLoader);
        StringBuilder classpath = new StringBuilder();
        File libDir = new File(this.jfxAppOutputDir, "lib");
        if (!libDir.exists() && !libDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create app lib dir: " + libDir);
        }
        if (this.updateExistingJar) {
            createJarParams.addResource(null, new File(build.getDirectory() + File.separator + build.getFinalName() + ".jar"));
        } else {
            createJarParams.addResource(new File(build.getOutputDirectory()), "");
        }
        try {
            for (Object object : this.project.getRuntimeClasspathElements()) {
                String path = (String)object;
                File file = new File(path);
                if (!file.isFile()) continue;
                this.getLog().debug((CharSequence)("Including classpath element: " + path));
                File dest = new File(libDir, file.getName());
                if (!dest.exists()) {
                    Files.copy(file.toPath(), dest.toPath(), new CopyOption[0]);
                }
                classpath.append("lib/").append(file.getName()).append(" ");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error resolving application classpath to use for application", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying dependency for application", (Exception)e);
        }
        createJarParams.setClasspath(classpath.toString());
        try {
            this.getPackagerLib().packageAsJar(createJarParams);
        }
        catch (PackagerException e) {
            throw new MojoExecutionException("Unable to build JFX JAR for application", (Exception)((Object)e));
        }
    }
}

