/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.deploy;

import com.zenjava.javafx.deploy.ApplicationProfile;
import com.zenjava.javafx.deploy.ApplicationTemplate;
import com.zenjava.javafx.deploy.BuildException;
import com.zenjava.javafx.deploy.log.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ApplicationTemplateProcessor {
    private Log log;

    public ApplicationTemplateProcessor(Log log) {
        this.log = log;
    }

    public void processTemplate(ApplicationTemplate templatePath, ApplicationProfile appProfile, File outputFile) throws BuildException {
        this.log.info("Processing template '%s' to create '%s'", templatePath, outputFile);
        this.log.debug("Initialising velocity templating engine", new Object[0]);
        VelocityEngine velocityEngine = new VelocityEngine();
        if (templatePath.isRelativeToClasspath()) {
            velocityEngine.setProperty("resource.loader", (Object)"classpath");
            velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        } else {
            velocityEngine.setProperty("resource.loader", (Object)"file");
            velocityEngine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            velocityEngine.setProperty("file.resource.loader.path", (Object)"");
        }
        velocityEngine.init();
        File outputDir = outputFile.getParentFile();
        this.log.debug("Creating base output directory: '%s'", outputDir);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new BuildException("Failed to create target directory '" + outputDir + "'for generation of '" + outputFile + "'");
        }
        Template template = velocityEngine.getTemplate(templatePath.getPath());
        VelocityContext context = new VelocityContext();
        context.put("app", (Object)appProfile);
        context.put("fileName", (Object)outputFile.getName());
        this.log.info("Generating file using template '%s', output file is '%s'", templatePath, outputFile);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(outputFile));
            template.merge((Context)context, (Writer)out);
        }
        catch (IOException e) {
            throw new BuildException("Failed to create file '" + outputFile + "' from template '" + templatePath + "'", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.log.info("Successfully generated file at '%s'", outputFile);
    }
}

