/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.deploy.webstart;

import com.zenjava.javafx.deploy.log.Log;
import com.zenjava.javafx.deploy.log.SimpleLog;
import com.zenjava.javafx.deploy.template.TemplateProcessor;
import com.zenjava.javafx.deploy.webstart.WebstartBundleConfig;
import com.zenjava.javafx.deploy.webstart.WebstartBundlerException;
import java.io.File;
import java.util.HashMap;

public class WebstartBundler {
    private Log log;
    private TemplateProcessor templateProcessor;

    public WebstartBundler() {
        this(Log.LogLevel.info);
    }

    public WebstartBundler(Log.LogLevel logLevel) {
        this(new SimpleLog(logLevel));
    }

    public WebstartBundler(Log log) {
        this.log = log;
        this.templateProcessor = new TemplateProcessor(log);
    }

    public void bundle(WebstartBundleConfig config) throws WebstartBundlerException {
        String jnlpTemplatePath;
        this.log.info("Creating Webstart bundle", new Object[0]);
        this.validate(config);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("config", config);
        this.log.info("Generating JNLP file for Webstart Bundle", new Object[0]);
        if (config.getJnlpTemplate() != null) {
            jnlpTemplatePath = config.getJnlpTemplate().getPath();
            this.log.debug("Using custom JNLP velocity template: '%s'", jnlpTemplatePath);
        } else {
            jnlpTemplatePath = "classpath:/webstart/default-jnlp-template.vm";
            this.log.debug("Using default JNLP velocity template: '%s'", jnlpTemplatePath);
        }
        File jnlpFile = new File(config.getOutputDir(), config.getJnlpFileName());
        this.templateProcessor.processTemplate(jnlpFile, jnlpTemplatePath, values);
        this.log.info("Successfully generated JNLP file at '%s'", jnlpFile);
        if (config.isBuildHtmlFile()) {
            String htmlTemplatePath;
            this.log.info("Generating HTML file for Webstart Bundle", new Object[0]);
            if (config.getJnlpTemplate() != null) {
                htmlTemplatePath = config.getJnlpTemplate().getPath();
                this.log.debug("Using custom Webstart HTML velocity template: '%s'", htmlTemplatePath);
            } else {
                htmlTemplatePath = "classpath:/webstart/default-webstart-html-template.vm";
                this.log.debug("Using default Webstart HTML velocity template: '%s'", htmlTemplatePath);
            }
            File htmlFile = new File(config.getOutputDir(), config.getHtmlFileName());
            this.templateProcessor.processTemplate(htmlFile, htmlTemplatePath, values);
            this.log.info("Successfully generated HTML file at '%s'", htmlFile);
        }
    }

    protected void validate(WebstartBundleConfig config) throws WebstartBundlerException {
        this.log.debug("Validating JNLP config", new Object[0]);
        this.assertNotNull("title", config.getTitle());
        this.assertNotNull("vendor", config.getVendor());
        this.assertNotNull("mainClass", config.getMainClass());
        this.assertNotNull("jarFile", config.getJarResources());
        if (config.isBuildHtmlFile()) {
            this.assertNotNull("htmlFileName", config.getHtmlFileName());
        }
    }

    private void assertNotNull(String key, Object value) throws WebstartBundlerException {
        if (value == null) {
            throw new WebstartBundlerException("A value must be set for '" + key + "'");
        }
    }
}

