/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.deploy.template;

import com.zenjava.javafx.deploy.log.Log;
import com.zenjava.javafx.deploy.template.TemplateException;
import com.zenjava.javafx.deploy.webstart.WebstartBundlerException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor {
    private Log log;

    public TemplateProcessor(Log log) {
        this.log = log;
    }

    public void processTemplate(File outputFile, String templatePath, Map<String, Object> values) throws TemplateException {
        this.log.info("Processing template '%s' to create '%s'", templatePath, outputFile);
        this.log.debug("Initialising velocity templating engine", new Object[0]);
        VelocityEngine velocityEngine = new VelocityEngine();
        if (templatePath.startsWith("classpath:")) {
            velocityEngine.setProperty("resource.loader", (Object)"classpath");
            velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            templatePath = templatePath.substring("classpath:".length());
        } else {
            velocityEngine.setProperty("resource.loader", (Object)"file");
            velocityEngine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            velocityEngine.setProperty("file.resource.loader.path", (Object)"");
        }
        velocityEngine.init();
        File outputDir = outputFile.getParentFile();
        this.log.debug("Creating base output directory: '%s'", outputDir);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new WebstartBundlerException("Failed to create target directory '" + outputDir + "'for generation of '" + outputFile + "'");
        }
        Template template = velocityEngine.getTemplate(templatePath);
        VelocityContext context = new VelocityContext();
        for (String key : values.keySet()) {
            context.put(key, values.get(key));
        }
        this.log.info("Generating file using template '%s', output file is '%s'", templatePath, outputFile);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(outputFile));
            template.merge((Context)context, (Writer)out);
        }
        catch (IOException e) {
            throw new WebstartBundlerException("Failed to create file '" + outputFile + "' from template '" + templatePath + "'", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.log.info("Successfully generated file at '%s'", outputFile);
    }
}

