/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization.json;

import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.json.JsonFormatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;

public class JsonStringFormatter
implements JsonFormatter {
    private static final int ESCAPE_NONE = 0;
    private static final int ESCAPE_GENERIC = -1;
    private static final int[] ESCAPES;
    private static final char[] HEX_CODES;
    private final StringBuilder sb = new StringBuilder();

    public String toString() {
        return this.getString();
    }

    public String getString() {
        return this.sb.toString();
    }

    @Override
    public void beginObject(int numElements) {
        this.sb.append('{');
    }

    @Override
    public void beginArray(int numElements) {
        this.sb.append('[');
    }

    @Override
    public void endObject() {
        this.sb.append('}');
    }

    @Override
    public void endArray() {
        this.sb.append(']');
    }

    @Override
    public void name(String name) {
        this.sb.append('\"');
        this.appendString(name);
        this.sb.append("\":");
    }

    @Override
    public void value(String value) {
        this.sb.append('\"');
        this.appendString(value);
        this.sb.append('\"');
    }

    @Override
    public void value(int value) {
        this.sb.append(Integer.toString(value));
    }

    @Override
    public void value(long value) {
        this.sb.append(Long.toString(value));
    }

    @Override
    public void value(double value) {
        String str = Double.toString(value);
        if (str.contains("E")) {
            this.value(new BigDecimal(value));
        } else {
            this.sb.append(str);
        }
    }

    @Override
    public void value(BigInteger value) {
        this.value(new BigDecimal(value));
    }

    @Override
    public void value(BigDecimal value) {
        this.sb.append(value.toPlainString());
    }

    @Override
    public void value(boolean value) {
        this.sb.append(Boolean.toString(value));
    }

    @Override
    public void valueNull() {
        this.sb.append("null");
    }

    @Override
    public void valueYear(int year) {
        this.sb.append(year);
    }

    @Override
    public void valueDate(int year, int month, int day) {
        this.sb.append('\"');
        this.appendDate(year, month, day);
        this.sb.append('\"');
    }

    @Override
    public void valueDatetime(int year, int month, int day, int hour, int min, int sec, int microSeconds) {
        this.sb.append('\"');
        this.appendDate(year, month, day);
        this.sb.append(' ');
        this.appendTime(hour, min, sec, microSeconds);
        this.sb.append('\"');
    }

    @Override
    public void valueTime(int hour, int min, int sec, int microSeconds) {
        this.sb.append('\"');
        if (hour < 0) {
            this.sb.append('-');
            hour = Math.abs(hour);
        }
        this.appendTime(hour, min, sec, microSeconds);
        this.sb.append('\"');
    }

    @Override
    public void valueTimestamp(long secondsPastEpoch, int microSeconds) {
        this.sb.append(secondsPastEpoch);
        this.appendSixDigitUnsignedInt(microSeconds, false);
    }

    @Override
    public void valueOpaque(ColumnType type, byte[] value) {
        this.sb.append('\"');
        this.sb.append(DatatypeConverter.printBase64Binary((byte[])value));
        this.sb.append('\"');
    }

    @Override
    public void nextEntry() {
        this.sb.append(',');
    }

    protected void appendString(String original) {
        int len = original.length();
        for (int i = 0; i < len; ++i) {
            char c = original.charAt(i);
            char ch = c;
            if (ch < '\u0000' || ch >= ESCAPES.length || ESCAPES[ch] == 0) {
                this.sb.append(c);
                continue;
            }
            int escape = ESCAPES[ch];
            if (escape > 0) {
                this.sb.append('\\');
                this.sb.append((char)escape);
                continue;
            }
            this.unicodeEscape(ch);
        }
    }

    private void unicodeEscape(int charToEscape) {
        this.sb.append('\\');
        this.sb.append('u');
        if (charToEscape > 255) {
            int hi = charToEscape >> 8 & 0xFF;
            this.sb.append(HEX_CODES[hi >> 4]);
            this.sb.append(HEX_CODES[hi & 0xF]);
            charToEscape &= 0xFF;
        } else {
            this.sb.append('0');
            this.sb.append('0');
        }
        this.sb.append(HEX_CODES[charToEscape >> 4]);
        this.sb.append(HEX_CODES[charToEscape & 0xF]);
    }

    protected void appendTwoDigitUnsignedInt(int value) {
        assert (value >= 0);
        assert (value < 100);
        if (value < 10) {
            this.sb.append("0").append(value);
        } else {
            this.sb.append(value);
        }
    }

    protected void appendFourDigitUnsignedInt(int value) {
        if (value < 10) {
            this.sb.append("000").append(value);
        } else if (value < 100) {
            this.sb.append("00").append(value);
        } else if (value < 1000) {
            this.sb.append("0").append(value);
        } else {
            this.sb.append(value);
        }
    }

    protected void appendSixDigitUnsignedInt(int value, boolean trimTrailingZeros) {
        assert (value > 0);
        assert (value < 1000000);
        if (value < 10) {
            this.sb.append("00000");
        } else if (value < 100) {
            this.sb.append("0000");
        } else if (value < 1000) {
            this.sb.append("000");
        } else if (value < 10000) {
            this.sb.append("00");
        } else if (value < 100000) {
            this.sb.append("0");
        }
        if (trimTrailingZeros) {
            for (int i = 0; i != 6; ++i) {
                if (value % 10 != 0) continue;
                value /= 10;
            }
            this.sb.append(value);
        }
    }

    protected void appendDate(int year, int month, int day) {
        if (year < 0) {
            this.sb.append('-');
            year = Math.abs(year);
        }
        this.appendFourDigitUnsignedInt(year);
        this.sb.append('-');
        this.appendTwoDigitUnsignedInt(month);
        this.sb.append('-');
        this.appendTwoDigitUnsignedInt(day);
    }

    protected void appendTime(int hour, int min, int sec, int microSeconds) {
        this.appendTwoDigitUnsignedInt(hour);
        this.sb.append(':');
        this.appendTwoDigitUnsignedInt(min);
        this.sb.append(':');
        this.appendTwoDigitUnsignedInt(sec);
        if (microSeconds != 0) {
            this.sb.append('.');
            this.appendSixDigitUnsignedInt(microSeconds, true);
        }
    }

    static {
        int[] escape = new int[128];
        for (int i = 0; i < 32; ++i) {
            escape[i] = -1;
        }
        escape[34] = 34;
        escape[92] = 92;
        escape[8] = 98;
        escape[9] = 116;
        escape[12] = 102;
        escape[10] = 110;
        escape[13] = 114;
        ESCAPES = escape;
        HEX_CODES = "0123456789ABCDEF".toCharArray();
    }
}

