/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.FastList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private static final Set<String> SQL_ERRORS = new HashSet<String>();
    protected final Connection delegate;
    private final HikariPool parentPool;
    private final PoolBagEntry bagEntry;
    private boolean forceClose;
    private boolean isAutoCommitDirty;
    private boolean isCatalogDirty;
    private boolean isClosed;
    private boolean isReadOnlyDirty;
    private boolean isTransactionIsolationDirty;
    private FastList<Statement> openStatements;
    private LeakTask leakTask;

    protected ConnectionProxy(HikariPool pool, PoolBagEntry bagEntry) {
        this.parentPool = pool;
        this.bagEntry = bagEntry;
        this.delegate = bagEntry.connection;
        this.openStatements = new FastList(Statement.class, 16);
    }

    public String toString() {
        return String.format("%s(%s) wrapping %s", this.getClass().getSimpleName(), System.identityHashCode(this), this.delegate);
    }

    @Override
    public PoolBagEntry getPoolBagEntry() {
        return this.bagEntry;
    }

    @Override
    public final void captureStack(long leakDetectionThreshold, ScheduledExecutorService executorService) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement[] leakTrace = new StackTraceElement[trace.length - 4];
        System.arraycopy(trace, 4, leakTrace, 0, leakTrace.length);
        this.leakTask = new LeakTask(leakTrace, leakDetectionThreshold);
        executorService.schedule(this.leakTask, leakDetectionThreshold, TimeUnit.MILLISECONDS);
    }

    @Override
    public final SQLException checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        if (sqlState != null) {
            this.forceClose |= sqlState.startsWith("08") | SQL_ERRORS.contains(sqlState);
            if (this.forceClose) {
                LOGGER.warn(String.format("Connection %s (%s) marked as broken because of SQLSTATE(%s), ErrorCode(%d).", this.delegate.toString(), this.parentPool.toString(), sqlState, sqle.getErrorCode()), (Throwable)sqle);
            } else if (sqle.getNextException() instanceof SQLException) {
                this.checkException(sqle.getNextException());
            }
        }
        return sqle;
    }

    @Override
    public final boolean isBrokenConnection() {
        return this.forceClose;
    }

    @Override
    public final void untrackStatement(Statement statement) {
        if (!this.isClosed) {
            this.openStatements.remove(statement);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    private <T extends Statement> T trackStatement(T statement) {
        this.openStatements.add(statement);
        return statement;
    }

    private final void resetConnectionState() throws SQLException {
        if (!this.delegate.getAutoCommit()) {
            this.delegate.rollback();
        }
        if (this.isReadOnlyDirty) {
            this.delegate.setReadOnly(this.parentPool.isReadOnly);
        }
        if (this.isAutoCommitDirty) {
            this.delegate.setAutoCommit(this.parentPool.isAutoCommit);
        }
        if (this.isTransactionIsolationDirty) {
            this.delegate.setTransactionIsolation(this.parentPool.transactionIsolation);
        }
        if (this.isCatalogDirty && this.parentPool.catalog != null) {
            this.delegate.setCatalog(this.parentPool.catalog);
        }
        this.delegate.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.leakTask != null) {
                this.leakTask.cancel();
                this.leakTask = null;
            }
            try {
                int size = this.openStatements.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        try {
                            this.openStatements.get(i).close();
                            continue;
                        }
                        catch (SQLException e) {
                            this.checkException(e);
                        }
                    }
                    this.openStatements = null;
                }
                this.resetConnectionState();
            }
            catch (SQLException e) {
                this.checkException(e);
            }
            finally {
                this.parentPool.releaseConnection(this.bagEntry, this.forceClose);
            }
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement());
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement proxyCallableStatement = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyCallableStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(timeout);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setAutoCommit(autoCommit);
            this.isAutoCommitDirty = autoCommit != this.parentPool.isAutoCommit;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setReadOnly(readOnly);
            this.isReadOnlyDirty = readOnly != this.parentPool.isReadOnly;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setTransactionIsolation(level);
            this.isTransactionIsolationDirty = level != this.parentPool.transactionIsolation;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setCatalog(catalog);
            this.isCatalogDirty = catalog != null && !catalog.equals(this.parentPool.catalog) || catalog == null && this.parentPool.catalog != null;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.delegate) || this.delegate instanceof Wrapper && this.delegate.isWrapperFor(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    static {
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("01002");
        SQL_ERRORS.add("JZ0C0");
        SQL_ERRORS.add("JZ0C1");
    }
}

