/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.pool.HikariPool;

public final class CodaHaleMetricsTracker
extends MetricsTracker {
    private MetricRegistry registry = new MetricRegistry();
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;

    public CodaHaleMetricsTracker(HikariPool pool) {
        super(pool);
        this.connectionObtainTimer = this.registry.timer(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"-connection", "Wait"}));
        this.connectionUsage = this.registry.histogram(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"-connection", "Wsage"}));
    }

    @Override
    public Context recordConnectionRequest(long requestTime) {
        return new Context(this.connectionObtainTimer);
    }

    @Override
    public void recordConnectionUsage(long usageMilleseconds) {
        this.connectionUsage.update(usageMilleseconds);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public static final class Context
    extends IMetricsTracker.MetricsContext {
        final Timer.Context innerContext;

        Context(Timer timer) {
            this.innerContext = timer.time();
        }

        @Override
        public void stop() {
            if (this.innerContext != null) {
                this.innerContext.stop();
            }
        }
    }
}

