/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NetworkMonitor {
    private static BroadcastReceiver networkStateReceiver;
    private static Map<NetworkChanged, Object> callbacks;
    private static boolean connected;

    public static synchronized void addMonitor(Context context, NetworkChanged callback) {
        callbacks.put(callback, true);
        if (networkStateReceiver == null) {
            context = context.getApplicationContext();
            connected = NetworkMonitor.isConnected(context);
            networkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkMonitor.doBroadcast(context);
                }
            };
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(networkStateReceiver, filter);
        }
        NetworkMonitor.notifyConnect(callback);
    }

    public static synchronized void removeMonitor(NetworkChanged callback) {
        if (callbacks != null && !callbacks.isEmpty()) {
            callbacks.remove(callback);
        }
    }

    private static synchronized void notifyConnect(NetworkChanged callback) {
        if (connected) {
            callback.onConnect();
        } else {
            callback.onDisconnect();
        }
    }

    private static synchronized void doBroadcast(Context context) {
        boolean newConnected = NetworkMonitor.isConnected(context);
        if (newConnected != connected) {
            connected = newConnected;
            for (NetworkChanged callback : callbacks.keySet()) {
                NetworkMonitor.notifyConnect(callback);
            }
        }
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    static {
        callbacks = new ConcurrentHashMap<NetworkChanged, Object>();
    }

    public static interface NetworkChanged {
        public void onConnect();

        public void onDisconnect();
    }
}

