/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.logging;

import android.text.TextUtils;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Logger {
    private static final List<Appender> APPENDERS = new ArrayList<Appender>();

    public static void init(Appender ... appenders) {
        Collections.addAll(APPENDERS, appenders);
    }

    public static void verbose(Object tag, String format, Object ... args) {
        Logger.writeLog(Level.VERBOSE, tag, format, args);
    }

    public static void debug(Object tag, String format, Object ... args) {
        Logger.writeLog(Level.DEBUG, tag, format, args);
    }

    public static void info(Object tag, String format, Object ... args) {
        Logger.writeLog(Level.INFO, tag, format, args);
    }

    public static void warn(Object tag, String format, Object ... args) {
        Logger.writeLog(Level.WARN, tag, format, args);
    }

    public static void error(Object tag, String format, Object ... args) {
        Logger.writeLog(Level.ERROR, tag, format, args);
    }

    public static void error(Object tag, Throwable t) {
        Logger.writeLog(Level.ERROR, tag, Logger.stackTraceOf(t), new Object[0]);
    }

    public static String stackTraceOf(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String stackTrace() {
        Object[] traces = Thread.currentThread().getStackTrace();
        return TextUtils.join((CharSequence)"\n", (Object[])traces);
    }

    private static void writeLog(Level level, Object tag, String format, Object ... args) {
        try {
            String message;
            String string = message = args == null || args.length == 0 ? format : String.format(format, args);
            if (args != null && args.length > 0 && args[args.length - 1] instanceof Throwable) {
                Throwable throwable = (Throwable)args[args.length - 1];
                message = Logger.getExceptionLogText(message, throwable);
            }
            for (Appender appender : APPENDERS) {
                appender.write(level, tag, message);
            }
        }
        catch (Exception e) {
            Log.e((String)"Logger", (String)String.format("write log failed: %s", e.toString()));
            e.printStackTrace();
        }
    }

    private static String getExceptionLogText(String message, Throwable throwable) {
        StringWriter sw = new StringWriter();
        sw.write(message);
        sw.write("\n");
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static String tag(Object tag) {
        return tag instanceof String ? (String)tag : tag.getClass().getSimpleName();
    }

    public static interface Appender {
        public void write(Level var1, Object var2, String var3);
    }

    public static enum Level {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

