/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util;

import android.os.Handler;

public abstract class DelayTask {
    private Handler mHandler;
    private long mDuration;
    private boolean hasTask;
    private long lastTime;

    public DelayTask(Handler handler, long duration) {
        this.mHandler = handler;
        this.mDuration = duration;
    }

    public abstract void runTask();

    public void run() {
        if (!this.hasTask) {
            long now = System.currentTimeMillis();
            long duration = now - this.lastTime;
            if (duration < this.mDuration) {
                this.hasTask = true;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        DelayTask.this.runTask();
                        DelayTask.this.hasTask = false;
                        DelayTask.this.lastTime = System.currentTimeMillis();
                    }
                }, this.mDuration - duration);
            } else {
                this.runTask();
                this.hasTask = false;
                this.lastTime = System.currentTimeMillis();
            }
        }
    }
}

