/*
 * Copyright 2012 <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yy.androidlib.util.prettytime.i18n;

import java.util.ListResourceBundle;
import java.util.ResourceBundle;

public class Resources_zh extends ListResourceBundle {

    private static Resources_zh instance;
    private static final Object[][] OBJECTS = new Object[][]{{"CenturyPattern", "%n%u"}, {"CenturyFuturePrefix", ""}, {"CenturyFutureSuffix", "后"}, {"CenturyPastPrefix", ""}, {"CenturyPastSuffix", "前"}, {"CenturySingularName", "世纪"}, {"CenturyPluralName", "世纪"}, {"DayPattern", "%n%u"}, {"DayFuturePrefix", ""}, {"DayFutureSuffix", "后"}, {"DayPastPrefix", ""}, {"DayPastSuffix", "前"}, {"DaySingularName", "天"}, {"DayPluralName", "天"}, {"DecadePattern", "%n%u"}, {"DecadeFuturePrefix", ""}, {"DecadeFutureSuffix", "后"}, {"DecadePastPrefix", ""}, {"DecadePastSuffix", "前"}, {"DecadeSingularName", "0 年"}, {"DecadePluralName", "0 年"}, {"HourPattern", "%n%u"}, {"HourFuturePrefix", ""}, {"HourFutureSuffix", "后"}, {"HourPastPrefix", ""}, {"HourPastSuffix", "前"}, {"HourSingularName", "小时"}, {"HourPluralName", "小时"}, {"JustNowPattern", "%u"}, {"JustNowFuturePrefix", ""}, {"JustNowFutureSuffix", "刚刚"}, {"JustNowPastPrefix", "刚刚"}, {"JustNowPastSuffix", ""}, {"JustNowSingularName", ""}, {"JustNowPluralName", ""}, {"MillenniumPattern", "%n%u"}, {"MillenniumFuturePrefix", ""}, {"MillenniumFutureSuffix", "后"}, {"MillenniumPastPrefix", ""}, {"MillenniumPastSuffix", "前"}, {"MillenniumSingularName", "千年"}, {"MillenniumPluralName", "千年"}, {"MillisecondPattern", "%n%u"}, {"MillisecondFuturePrefix", ""}, {"MillisecondFutureSuffix", "后"}, {"MillisecondPastPrefix", ""}, {"MillisecondPastSuffix", "前"}, {"MillisecondSingularName", "毫秒"}, {"MillisecondPluralName", "毫秒"}, {"MinutePattern", "%n%u"}, {"MinuteFuturePrefix", ""}, {"MinuteFutureSuffix", "后"}, {"MinutePastPrefix", ""}, {"MinutePastSuffix", "前"}, {"MinuteSingularName", "分钟"}, {"MinutePluralName", "分钟"}, {"MonthPattern", "%n%u"}, {"MonthFuturePrefix", ""}, {"MonthFutureSuffix", "后"}, {"MonthPastPrefix", ""}, {"MonthPastSuffix", "前"}, {"MonthSingularName", "个月"}, {"MonthPluralName", "个月"}, {"SecondPattern", "%n%u"}, {"SecondFuturePrefix", ""}, {"SecondFutureSuffix", "后"}, {"SecondPastPrefix", ""}, {"SecondPastSuffix", "前"}, {"SecondSingularName", "秒"}, {"SecondPluralName", "秒"}, {"WeekPattern", "%n%u"}, {"WeekFuturePrefix", ""}, {"WeekFutureSuffix", "后"}, {"WeekPastPrefix", ""}, {"WeekPastSuffix", "前"}, {"WeekSingularName", "周"}, {"WeekPluralName", "周"}, {"YearPattern", "%n%u"}, {"YearFuturePrefix", ""}, {"YearFutureSuffix", "后"}, {"YearPastPrefix", ""}, {"YearPastSuffix", "前"}, {"YearSingularName", "年"}, {"YearPluralName", "年"}, {"AbstractTimeUnitPattern", ""}, {"AbstractTimeUnitFuturePrefix", ""}, {"AbstractTimeUnitFutureSuffix", ""}, {"AbstractTimeUnitPastPrefix", ""}, {"AbstractTimeUnitPastSuffix", ""}, {"AbstractTimeUnitSingularName", ""}, {"AbstractTimeUnitPluralName", ""}};

    @Override
    protected Object[][] getContents() {
        return OBJECTS;
    }

    public static ResourceBundle instance() {
        if (instance == null) {
            instance = new Resources_zh();
        }
        return instance;
    }
}
