/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.ui;

import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.KeyEvent;

public class OtpKeyListener {
    private static final int OTP_DELAY_MS = 1000;
    private static final int YUBICO_VID = 4176;
    private final SparseArray<StringBuilder> inputBuffers = new SparseArray();
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final OtpListener listener;

    public OtpKeyListener(OtpListener listener) {
        this.listener = listener;
    }

    public boolean onKeyEvent(KeyEvent event) {
        InputDevice device = event.getDevice();
        if (device == null || device.getVendorId() != 4176) {
            return false;
        }
        if (event.getAction() == 1) {
            int deviceId = event.getDeviceId();
            StringBuilder otpBuffer = (StringBuilder)this.inputBuffers.get(deviceId, (Object)new StringBuilder());
            if (event.getKeyCode() == 66 || event.getKeyCode() == 160) {
                this.listener.onCaptureComplete(otpBuffer.toString());
                this.inputBuffers.delete(deviceId);
            } else {
                if (otpBuffer.length() == 0) {
                    this.handler.postDelayed(() -> {
                        StringBuilder otpBuffer1 = (StringBuilder)this.inputBuffers.get(deviceId, (Object)new StringBuilder());
                        if (otpBuffer1.length() > 0) {
                            this.listener.onCaptureComplete(otpBuffer1.toString());
                            this.inputBuffers.delete(deviceId);
                        }
                    }, 1000L);
                    this.listener.onCaptureStarted();
                }
                otpBuffer.append((char)event.getUnicodeChar());
                this.inputBuffers.put(deviceId, (Object)otpBuffer);
            }
        }
        return true;
    }

    public static interface OtpListener {
        public void onCaptureStarted();

        public void onCaptureComplete(String var1);
    }
}

