/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import androidx.annotation.WorkerThread;
import com.yubico.yubikit.android.transport.usb.NoPermissionsException;
import com.yubico.yubikit.android.transport.usb.connection.ConnectionHandler;
import com.yubico.yubikit.core.YubiKeyConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ConnectionManager {
    private static final Map<Class<? extends YubiKeyConnection>, ConnectionHandler<?>> handlers = new HashMap();
    private final UsbManager usbManager;
    private final UsbDevice usbDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends YubiKeyConnection> void registerConnectionHandler(Class<T> connectionClass, ConnectionHandler<? extends T> handler) {
        Map<Class<? extends YubiKeyConnection>, ConnectionHandler<?>> map = handlers;
        synchronized (map) {
            handlers.put(connectionClass, handler);
        }
    }

    public ConnectionManager(UsbManager usbManager, UsbDevice usbDevice) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
    }

    public boolean supportsConnection(Class<? extends YubiKeyConnection> connectionType) {
        ConnectionHandler<? extends YubiKeyConnection> handler = this.getHandler(connectionType);
        return handler != null && handler.isAvailable(this.usbDevice);
    }

    @WorkerThread
    public <T extends YubiKeyConnection> T openConnection(Class<T> connectionType) throws IOException {
        ConnectionHandler<T> handler = this.getHandler(connectionType);
        if (handler != null) {
            UsbDeviceConnection usbDeviceConnection = this.openDeviceConnection(this.usbDevice);
            try {
                return handler.createConnection(this.usbDevice, usbDeviceConnection);
            }
            catch (IOException e) {
                usbDeviceConnection.close();
                throw e;
            }
        }
        throw new IllegalStateException("The connection type is not available via this transport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends YubiKeyConnection> ConnectionHandler<T> getHandler(Class<T> connectionType) {
        Map<Class<? extends YubiKeyConnection>, ConnectionHandler<?>> map = handlers;
        synchronized (map) {
            for (Map.Entry<Class<YubiKeyConnection>, ConnectionHandler<?>> entry : handlers.entrySet()) {
                if (!connectionType.isAssignableFrom(entry.getKey())) continue;
                ConnectionHandler<?> entryValue = entry.getValue();
                return entryValue;
            }
        }
        return null;
    }

    private UsbDeviceConnection openDeviceConnection(UsbDevice usbDevice) throws IOException {
        if (!this.usbManager.hasPermission(usbDevice)) {
            throw new NoPermissionsException(usbDevice);
        }
        return this.usbManager.openDevice(usbDevice);
    }
}

