/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.ui;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.yubico.yubikit.android.ui.YubiKeyPromptAction;
import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.YubiKeyConnection;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.application.CommandState;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Pair;
import java.io.IOException;

public abstract class YubiKeyPromptConnectionAction<T extends YubiKeyConnection>
extends YubiKeyPromptAction {
    final Class<T> connectionType;

    protected YubiKeyPromptConnectionAction(Class<T> connectionType) {
        this.connectionType = connectionType;
    }

    @Override
    final void onYubiKey(YubiKeyDevice device, Bundle extras, CommandState commandState, Callback<Pair<Integer, Intent>> callback) {
        if (device.supportsConnection(this.connectionType)) {
            device.requestConnection(this.connectionType, value -> {
                try {
                    callback.invoke(this.onYubiKeyConnection((YubiKeyConnection)value.getValue(), extras, commandState));
                }
                catch (IOException exception) {
                    this.onError(exception);
                }
            });
        } else {
            Logger.d((String)"Connected YubiKey does not support desired connection type");
            callback.invoke((Object)CONTINUE);
        }
    }

    @WorkerThread
    protected abstract Pair<Integer, Intent> onYubiKeyConnection(T var1, Bundle var2, CommandState var3);

    @WorkerThread
    protected void onError(Exception exception) {
        Logger.e((String)"Error connecting to YubiKey", (Throwable)exception);
    }
}

