/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import com.yubico.yubikit.android.R;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.ui.OtpKeyListener;
import com.yubico.yubikit.android.ui.YubiKeyPromptAction;
import com.yubico.yubikit.android.ui.YubiKeyPromptActivity;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.application.CommandState;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.NdefUtils;
import com.yubico.yubikit.core.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;

public class OtpActivity
extends YubiKeyPromptActivity {
    public static final int RESULT_ERROR = 1;
    public static final String EXTRA_OTP = "otp";
    public static final String EXTRA_ERROR = "error";
    private OtpKeyListener keyListener;
    private int usbSessionCounter = 0;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.getIntent().putExtra("ACTION_CLASS", YubiKeyNdefAction.class);
        this.getIntent().putExtra("ALLOW_USB", false);
        super.onCreate(savedInstanceState);
        this.getYubiKitManager().startUsbDiscovery(new UsbConfiguration().handlePermissions(false), (Callback<? super UsbYubiKeyDevice>)((Callback)device -> {
            ++this.usbSessionCounter;
            device.setOnClosed(() -> {
                --this.usbSessionCounter;
                if (this.usbSessionCounter == 0) {
                    this.runOnUiThread(() -> this.helpTextView.setText(this.isNfcEnabled() ? R.string.yubikit_prompt_plug_in_or_tap : R.string.yubikit_prompt_plug_in));
                }
            });
            this.runOnUiThread(() -> this.helpTextView.setText(R.string.yubikit_otp_touch));
        }));
        this.keyListener = new OtpKeyListener(new OtpKeyListener.OtpListener(){

            @Override
            public void onCaptureStarted() {
                OtpActivity.this.helpTextView.setText(R.string.yubikit_prompt_wait);
            }

            @Override
            public void onCaptureComplete(String capture) {
                Intent intent = new Intent();
                intent.putExtra(OtpActivity.EXTRA_OTP, capture);
                OtpActivity.this.setResult(-1, intent);
                OtpActivity.this.finish();
            }
        });
    }

    @Override
    protected void onDestroy() {
        this.getYubiKitManager().stopUsbDiscovery();
        super.onDestroy();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.keyListener.onKeyEvent(event);
    }

    static class YubiKeyNdefAction
    extends YubiKeyPromptAction {
        YubiKeyNdefAction() {
        }

        @Override
        void onYubiKey(YubiKeyDevice device, Bundle extras, CommandState commandState, Callback<Pair<Integer, Intent>> callback) {
            if (device instanceof NfcYubiKeyDevice) {
                Intent intent = new Intent();
                try {
                    String credential = NdefUtils.getNdefPayload((byte[])((NfcYubiKeyDevice)device).readNdef());
                    intent.putExtra(OtpActivity.EXTRA_OTP, credential);
                    callback.invoke((Object)new Pair((Object)-1, (Object)intent));
                }
                catch (IOException e) {
                    intent.putExtra(OtpActivity.EXTRA_ERROR, (Serializable)e);
                    callback.invoke((Object)new Pair((Object)1, (Object)intent));
                }
            }
        }
    }
}

