/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbDeviceManager;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.connection.ConnectionManager;
import com.yubico.yubikit.android.transport.usb.connection.OtpConnectionHandler;
import com.yubico.yubikit.android.transport.usb.connection.SmartCardConnectionHandler;
import com.yubico.yubikit.android.transport.usb.connection.UsbOtpConnection;
import com.yubico.yubikit.android.transport.usb.connection.UsbSmartCardConnection;
import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.util.Callback;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class UsbYubiKeyManager {
    private final Context context;
    private final UsbManager usbManager;
    @Nullable
    private MyDeviceListener internalListener = null;

    public UsbYubiKeyManager(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public synchronized void enable(UsbConfiguration usbConfiguration, Callback<? super UsbYubiKeyDevice> listener) {
        this.disable();
        this.internalListener = new MyDeviceListener(usbConfiguration, listener);
        UsbDeviceManager.registerUsbListener(this.context, this.internalListener);
    }

    public synchronized void disable() {
        if (this.internalListener != null) {
            UsbDeviceManager.unregisterUsbListener(this.context, this.internalListener);
            this.internalListener = null;
        }
    }

    static {
        ConnectionManager.registerConnectionHandler(UsbSmartCardConnection.class, new SmartCardConnectionHandler());
        ConnectionManager.registerConnectionHandler(UsbOtpConnection.class, new OtpConnectionHandler());
    }

    private class MyDeviceListener
    implements UsbDeviceManager.UsbDeviceListener {
        private final Callback<? super UsbYubiKeyDevice> listener;
        private final UsbConfiguration usbConfiguration;
        private final Map<UsbDevice, UsbYubiKeyDevice> devices = new HashMap<UsbDevice, UsbYubiKeyDevice>();

        private MyDeviceListener(UsbConfiguration usbConfiguration, Callback<? super UsbYubiKeyDevice> listener) {
            this.usbConfiguration = usbConfiguration;
            this.listener = listener;
        }

        @Override
        public void deviceAttached(UsbDevice usbDevice) {
            try {
                UsbYubiKeyDevice yubikey = new UsbYubiKeyDevice(UsbYubiKeyManager.this.usbManager, usbDevice);
                this.devices.put(usbDevice, yubikey);
                if (this.usbConfiguration.isHandlePermissions() && !yubikey.hasPermission()) {
                    Logger.d((String)"request permission");
                    UsbDeviceManager.requestPermission(UsbYubiKeyManager.this.context, usbDevice, (usbDevice1, hasPermission) -> {
                        Logger.d((String)("permission result " + hasPermission));
                        if (hasPermission) {
                            UsbYubiKeyManager usbYubiKeyManager = UsbYubiKeyManager.this;
                            synchronized (usbYubiKeyManager) {
                                if (UsbYubiKeyManager.this.internalListener == this) {
                                    this.listener.invoke((Object)yubikey);
                                }
                            }
                        }
                    });
                } else {
                    this.listener.invoke((Object)yubikey);
                }
            }
            catch (IllegalArgumentException ignored) {
                Logger.d((String)("Attached usbDevice(vid=" + usbDevice.getVendorId() + ",pid=" + usbDevice.getProductId() + ") is not recognized as a valid YubiKey"));
            }
        }

        @Override
        public void deviceRemoved(UsbDevice usbDevice) {
            UsbYubiKeyDevice yubikey = this.devices.remove(usbDevice);
            if (yubikey != null) {
                yubikey.close();
            }
        }
    }
}

