/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.nfc;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import com.yubico.yubikit.android.transport.nfc.NfcConfiguration;
import com.yubico.yubikit.android.transport.nfc.NfcDispatcher;
import com.yubico.yubikit.android.transport.nfc.NfcNotAvailable;
import com.yubico.yubikit.android.transport.nfc.NfcReaderDispatcher;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyDevice;
import com.yubico.yubikit.core.util.Callback;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class NfcYubiKeyManager {
    public static final String NFC_SETTINGS_ACTION = "android.settings.NFC_SETTINGS";
    private final Context context;
    private final NfcAdapter adapter;
    private final NfcDispatcher dispatcher;
    @Nullable
    private ExecutorService executorService = null;

    public NfcYubiKeyManager(Context context, @Nullable NfcDispatcher dispatcher) throws NfcNotAvailable {
        this.adapter = NfcAdapter.getDefaultAdapter((Context)context);
        if (this.adapter == null) {
            throw new NfcNotAvailable("NFC unavailable on this device", false);
        }
        if (dispatcher == null) {
            dispatcher = new NfcReaderDispatcher(this.adapter);
        }
        this.dispatcher = dispatcher;
        this.context = context;
    }

    public void enable(Activity activity, NfcConfiguration nfcConfiguration, Callback<? super NfcYubiKeyDevice> listener) throws NfcNotAvailable {
        if (this.checkAvailability(nfcConfiguration.isHandleUnavailableNfc())) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.dispatcher.enable(activity, nfcConfiguration, (Tag tag) -> listener.invoke((Object)new NfcYubiKeyDevice(tag, nfcConfiguration.getTimeout(), executor)));
            this.executorService = executor;
        }
    }

    public void disable(Activity activity) {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.dispatcher.disable(activity);
    }

    private boolean checkAvailability(boolean handleUnavailableNfc) throws NfcNotAvailable {
        if (this.adapter.isEnabled()) {
            return true;
        }
        if (handleUnavailableNfc) {
            this.context.startActivity(new Intent(NFC_SETTINGS_ACTION));
            return false;
        }
        throw new NfcNotAvailable("Please activate NFC_TRANSPORT", true);
    }
}

