/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.nfc;

import android.app.Activity;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import com.yubico.yubikit.android.transport.nfc.NfcConfiguration;
import com.yubico.yubikit.android.transport.nfc.NfcDispatcher;

public class NfcReaderDispatcher
implements NfcDispatcher {
    private final NfcAdapter adapter;

    public NfcReaderDispatcher(NfcAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void enable(Activity activity, NfcConfiguration nfcConfiguration, NfcDispatcher.OnTagHandler handler) {
        this.disableReaderMode(activity);
        this.enableReaderMode(activity, nfcConfiguration, handler);
    }

    @Override
    public void disable(Activity activity) {
        this.disableReaderMode(activity);
    }

    private void enableReaderMode(Activity activity, NfcConfiguration nfcConfiguration, NfcDispatcher.OnTagHandler handler) {
        Bundle options = new Bundle();
        options.putInt("presence", 50);
        int READER_FLAGS = 3;
        if (nfcConfiguration.isDisableNfcDiscoverySound()) {
            READER_FLAGS |= 0x100;
        }
        if (nfcConfiguration.isSkipNdefCheck()) {
            READER_FLAGS |= 0x80;
        }
        this.adapter.enableReaderMode(activity, handler::onTag, READER_FLAGS, options);
    }

    private void disableReaderMode(Activity activity) {
        this.adapter.disableReaderMode(activity);
    }
}

