/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2.impl;

import com.yubico.client.v2.HttpUtils;
import com.yubico.client.v2.ResponseStatus;
import com.yubico.client.v2.Signature;
import com.yubico.client.v2.VerificationRequester;
import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.YubicoClient;
import com.yubico.client.v2.exceptions.YubicoSignatureException;
import com.yubico.client.v2.exceptions.YubicoValidationFailure;
import com.yubico.client.v2.exceptions.YubicoVerificationException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class YubicoClientImpl
extends YubicoClient {
    private final VerificationRequester validationService = new VerificationRequester();

    public YubicoClientImpl(Integer clientId) {
        this.clientId = clientId;
    }

    public YubicoClientImpl(Integer clientId, String apiKey) {
        this(clientId);
        this.setKey(apiKey);
    }

    public YubicoClientImpl(Integer clientId, String apiKey, Integer sync) {
        this(clientId, apiKey);
        this.setSync(sync);
    }

    public VerificationResponse verify(String otp) throws YubicoVerificationException, YubicoValidationFailure {
        String queryString;
        if (!YubicoClientImpl.isValidOTPFormat(otp)) {
            throw new IllegalArgumentException("The OTP is not a valid format");
        }
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        String nonce = UUID.randomUUID().toString().replaceAll("-", "");
        requestMap.put("nonce", nonce);
        requestMap.put("id", this.clientId.toString());
        requestMap.put("otp", otp);
        requestMap.put("timestamp", "1");
        if (this.sync != null) {
            requestMap.put("sl", this.sync.toString());
        }
        try {
            queryString = HttpUtils.toQueryString(requestMap);
        }
        catch (UnsupportedEncodingException e) {
            throw new YubicoVerificationException("Failed to encode parameter.", e);
        }
        if (this.key != null) {
            queryString = this.sign(queryString);
        }
        String[] wsapiUrls = this.getWsapiUrls();
        ArrayList<String> validationUrls = new ArrayList<String>();
        for (String wsapiUrl : wsapiUrls) {
            validationUrls.add(wsapiUrl + "?" + queryString);
        }
        VerificationResponse response = this.validationService.fetch(validationUrls, this.userAgent);
        if (this.key != null) {
            this.verifySignature(response);
        }
        if (!response.getStatus().isError()) {
            if (response.getOtp() == null || !otp.equals(response.getOtp())) {
                throw new YubicoValidationFailure("OTP mismatch in response, is there a man-in-the-middle?");
            }
            if (response.getNonce() == null || !nonce.equals(response.getNonce())) {
                throw new YubicoValidationFailure("Nonce mismatch in response, is there a man-in-the-middle?");
            }
        }
        return response;
    }

    private void verifySignature(VerificationResponse response) throws YubicoValidationFailure, YubicoVerificationException {
        StringBuilder keyValueStr = new StringBuilder();
        for (Map.Entry<String, String> entry : response.getKeyValueMap().entrySet()) {
            if ("h".equals(entry.getKey())) continue;
            if (keyValueStr.length() > 0) {
                keyValueStr.append("&");
            }
            keyValueStr.append(entry.getKey()).append("=").append(entry.getValue());
        }
        try {
            String signature = Signature.calculate(keyValueStr.toString(), this.key).trim();
            if (!response.getH().equals(signature) && !response.getStatus().equals((Object)ResponseStatus.BAD_SIGNATURE)) {
                throw new YubicoValidationFailure("Signatures do not match");
            }
        }
        catch (YubicoSignatureException e) {
            throw new YubicoVerificationException("Failed to calculate the response signature.", e);
        }
    }

    private String sign(String queryString) throws YubicoVerificationException {
        try {
            queryString = queryString + "&h=" + URLEncoder.encode(Signature.calculate(queryString, this.key), "UTF-8");
        }
        catch (YubicoSignatureException e) {
            throw new YubicoVerificationException("Failed signing of request", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new YubicoVerificationException("Failed to encode signature", e);
        }
        return queryString;
    }
}

