/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.exception;

import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.exception.AssertionFailedException;
import lombok.Generated;

public final class InvalidSignatureCountException
extends AssertionFailedException {
    private final ByteArray credentialId;
    private final long expectedMinimum;
    private final long received;

    public InvalidSignatureCountException(ByteArray credentialId, long expectedMinimum, long received) {
        super(String.format("Signature counter must increase. Expected minimum: %s, received value: %s", expectedMinimum, received));
        this.credentialId = credentialId;
        this.expectedMinimum = expectedMinimum;
        this.received = received;
    }

    @Generated
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @Generated
    public long getExpectedMinimum() {
        return this.expectedMinimum;
    }

    @Generated
    public long getReceived() {
        return this.received;
    }

    @Override
    @Generated
    public String toString() {
        return "InvalidSignatureCountException(credentialId=" + this.getCredentialId() + ", expectedMinimum=" + this.getExpectedMinimum() + ", received=" + this.getReceived() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvalidSignatureCountException)) {
            return false;
        }
        InvalidSignatureCountException other = (InvalidSignatureCountException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        if (this.getExpectedMinimum() != other.getExpectedMinimum()) {
            return false;
        }
        return this.getReceived() == other.getReceived();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvalidSignatureCountException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        long $expectedMinimum = this.getExpectedMinimum();
        result = result * 59 + (int)($expectedMinimum >>> 32 ^ $expectedMinimum);
        long $received = this.getReceived();
        result = result * 59 + (int)($received >>> 32 ^ $received);
        return result;
    }
}

