/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.AssertionExtensionInputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialRequestOptions {
    @NonNull
    private final ByteArray challenge;
    private final Long timeout;
    private final String rpId;
    private final List<PublicKeyCredentialDescriptor> allowCredentials;
    @NonNull
    private final UserVerificationRequirement userVerification;
    @NonNull
    private final AssertionExtensionInputs extensions;

    @JsonCreator
    private PublicKeyCredentialRequestOptions(@JsonProperty(value="challenge") @NonNull ByteArray challenge, @JsonProperty(value="timeout") Long timeout, @JsonProperty(value="rpId") String rpId, @JsonProperty(value="allowCredentials") List<PublicKeyCredentialDescriptor> allowCredentials, @JsonProperty(value="userVerification") @NonNull UserVerificationRequirement userVerification, @JsonProperty(value="extensions") @NonNull AssertionExtensionInputs extensions) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        if (userVerification == null) {
            throw new NullPointerException("userVerification is marked non-null but is null");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions is marked non-null but is null");
        }
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = allowCredentials == null ? null : CollectionUtil.immutableList(allowCredentials);
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<List<PublicKeyCredentialDescriptor>> getAllowCredentials() {
        return Optional.ofNullable(this.allowCredentials);
    }

    public static PublicKeyCredentialRequestOptionsBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialRequestOptionsBuilder.MandatoryStages();
    }

    private Optional<Long> wrapTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Generated
    private static UserVerificationRequirement $default$userVerification() {
        return UserVerificationRequirement.PREFERRED;
    }

    @Generated
    private static AssertionExtensionInputs $default$extensions() {
        return AssertionExtensionInputs.builder().build();
    }

    @Generated
    public PublicKeyCredentialRequestOptionsBuilder toBuilder() {
        return new PublicKeyCredentialRequestOptionsBuilder().challenge(this.challenge).timeout(this.wrapTimeout()).rpId(this.rpId).allowCredentials(this.allowCredentials).userVerification(this.userVerification).extensions(this.extensions);
    }

    @NonNull
    @Generated
    public ByteArray getChallenge() {
        return this.challenge;
    }

    @Generated
    public String getRpId() {
        return this.rpId;
    }

    @NonNull
    @Generated
    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    @NonNull
    @Generated
    public AssertionExtensionInputs getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialRequestOptions)) {
            return false;
        }
        PublicKeyCredentialRequestOptions other = (PublicKeyCredentialRequestOptions)o;
        ByteArray this$challenge = this.getChallenge();
        ByteArray other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !((Object)this$challenge).equals(other$challenge)) {
            return false;
        }
        Optional<Long> this$timeout = this.getTimeout();
        Optional<Long> other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$rpId = this.getRpId();
        String other$rpId = other.getRpId();
        if (this$rpId == null ? other$rpId != null : !this$rpId.equals(other$rpId)) {
            return false;
        }
        Optional<List<PublicKeyCredentialDescriptor>> this$allowCredentials = this.getAllowCredentials();
        Optional<List<PublicKeyCredentialDescriptor>> other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        UserVerificationRequirement this$userVerification = this.getUserVerification();
        UserVerificationRequirement other$userVerification = other.getUserVerification();
        if (this$userVerification == null ? other$userVerification != null : !((Object)((Object)this$userVerification)).equals((Object)other$userVerification)) {
            return false;
        }
        AssertionExtensionInputs this$extensions = this.getExtensions();
        AssertionExtensionInputs other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : ((Object)$challenge).hashCode());
        Optional<Long> $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $rpId = this.getRpId();
        result = result * 59 + ($rpId == null ? 43 : $rpId.hashCode());
        Optional<List<PublicKeyCredentialDescriptor>> $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        UserVerificationRequirement $userVerification = this.getUserVerification();
        result = result * 59 + ($userVerification == null ? 43 : ((Object)((Object)$userVerification)).hashCode());
        AssertionExtensionInputs $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialRequestOptions(challenge=" + this.getChallenge() + ", timeout=" + this.getTimeout() + ", rpId=" + this.getRpId() + ", allowCredentials=" + this.getAllowCredentials() + ", userVerification=" + (Object)((Object)this.getUserVerification()) + ", extensions=" + this.getExtensions() + ")";
    }

    public static class PublicKeyCredentialRequestOptionsBuilder {
        @Generated
        private ByteArray challenge;
        @Generated
        private boolean userVerification$set;
        @Generated
        private UserVerificationRequirement userVerification$value;
        @Generated
        private boolean extensions$set;
        @Generated
        private AssertionExtensionInputs extensions$value;
        private Long timeout = null;
        private String rpId = null;
        private List<PublicKeyCredentialDescriptor> allowCredentials = null;

        public PublicKeyCredentialRequestOptionsBuilder timeout(@NonNull Optional<Long> timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout.orElse(null);
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder timeout(long timeout) {
            return this.timeout(Optional.of(timeout));
        }

        public PublicKeyCredentialRequestOptionsBuilder rpId(@NonNull Optional<String> rpId) {
            if (rpId == null) {
                throw new NullPointerException("rpId is marked non-null but is null");
            }
            return this.rpId((String)rpId.orElse(null));
        }

        public PublicKeyCredentialRequestOptionsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(@NonNull Optional<List<PublicKeyCredentialDescriptor>> allowCredentials) {
            if (allowCredentials == null) {
                throw new NullPointerException("allowCredentials is marked non-null but is null");
            }
            return this.allowCredentials((List<PublicKeyCredentialDescriptor>)allowCredentials.orElse(null));
        }

        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(List<PublicKeyCredentialDescriptor> allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        @Generated
        PublicKeyCredentialRequestOptionsBuilder() {
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder challenge(@NonNull ByteArray challenge) {
            if (challenge == null) {
                throw new NullPointerException("challenge is marked non-null but is null");
            }
            this.challenge = challenge;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder userVerification(@NonNull UserVerificationRequirement userVerification) {
            if (userVerification == null) {
                throw new NullPointerException("userVerification is marked non-null but is null");
            }
            this.userVerification$value = userVerification;
            this.userVerification$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptionsBuilder extensions(@NonNull AssertionExtensionInputs extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions is marked non-null but is null");
            }
            this.extensions$value = extensions;
            this.extensions$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialRequestOptions build() {
            UserVerificationRequirement userVerification$value = this.userVerification$value;
            if (!this.userVerification$set) {
                userVerification$value = PublicKeyCredentialRequestOptions.$default$userVerification();
            }
            AssertionExtensionInputs extensions$value = this.extensions$value;
            if (!this.extensions$set) {
                extensions$value = PublicKeyCredentialRequestOptions.$default$extensions();
            }
            return new PublicKeyCredentialRequestOptions(this.challenge, this.timeout, this.rpId, this.allowCredentials, userVerification$value, extensions$value);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder(challenge=" + this.challenge + ", timeout=" + this.timeout + ", rpId=" + this.rpId + ", allowCredentials=" + this.allowCredentials + ", userVerification$value=" + (Object)((Object)this.userVerification$value) + ", extensions$value=" + this.extensions$value + ")";
        }

        public static class MandatoryStages {
            private PublicKeyCredentialRequestOptionsBuilder builder = new PublicKeyCredentialRequestOptionsBuilder();

            public PublicKeyCredentialRequestOptionsBuilder challenge(ByteArray challenge) {
                return this.builder.challenge(challenge);
            }
        }
    }
}

