/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.internal.util.BinaryUtil;
import com.yubico.internal.util.json.JsonStringSerializable;
import com.yubico.internal.util.json.JsonStringSerializer;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.data.exception.HexException;
import java.util.Base64;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.util.Arrays;

@JsonSerialize(using=JsonStringSerializer.class)
public final class ByteArray
implements Comparable<ByteArray>,
JsonStringSerializable {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64URL_DECODER = Base64.getUrlDecoder();
    @NonNull
    private final byte[] bytes;
    @NonNull
    private final String base64;

    public ByteArray(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        this.bytes = BinaryUtil.copy((byte[])bytes);
        this.base64 = BASE64URL_ENCODER.encodeToString(this.bytes);
    }

    private ByteArray(String base64) throws Base64UrlException {
        try {
            this.bytes = BASE64URL_DECODER.decode(base64);
        }
        catch (IllegalArgumentException e) {
            throw new Base64UrlException("Invalid Base64Url encoding: " + base64, e);
        }
        this.base64 = base64;
    }

    public static ByteArray fromBase64(@NonNull String base64) {
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        return new ByteArray(BASE64_DECODER.decode(base64));
    }

    @JsonCreator
    public static ByteArray fromBase64Url(@NonNull String base64) throws Base64UrlException {
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        return new ByteArray(base64);
    }

    public static ByteArray fromHex(@NonNull String hex) throws HexException {
        if (hex == null) {
            throw new NullPointerException("hex is marked non-null but is null");
        }
        try {
            return new ByteArray(BinaryUtil.fromHex((String)hex));
        }
        catch (Exception e) {
            throw new HexException("Invalid hexadecimal encoding: " + hex, e);
        }
    }

    public ByteArray concat(@NonNull ByteArray tail) {
        if (tail == null) {
            throw new NullPointerException("tail is marked non-null but is null");
        }
        return new ByteArray(Arrays.concatenate((byte[])this.bytes, (byte[])tail.bytes));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return BinaryUtil.copy((byte[])this.bytes);
    }

    public String getBase64() {
        return BASE64_ENCODER.encodeToString(this.bytes);
    }

    public String getBase64Url() {
        return this.base64;
    }

    public String getHex() {
        return BinaryUtil.toHex((byte[])this.bytes);
    }

    public String toJsonString() {
        return this.base64;
    }

    @Override
    public int compareTo(ByteArray other) {
        if (this.bytes.length != other.bytes.length) {
            return this.bytes.length - other.bytes.length;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return this.bytes[i] - other.bytes[i];
        }
        return 0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        if (!java.util.Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        String this$base64 = this.getBase64();
        String other$base64 = other.getBase64();
        return !(this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + java.util.Arrays.hashCode(this.getBytes());
        String $base64 = this.getBase64();
        result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ByteArray(" + this.getHex() + ")";
    }
}

