/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

final class BouncyCastleCrypto {
    private static final Provider provider = new BouncyCastleProvider();

    BouncyCastleCrypto() {
    }

    public Provider getProvider() {
        return provider;
    }

    public boolean verifySignature(X509Certificate attestationCertificate, ByteArray signedBytes, ByteArray signature, COSEAlgorithmIdentifier alg) {
        return this.verifySignature(attestationCertificate.getPublicKey(), signedBytes, signature, alg);
    }

    public boolean verifySignature(PublicKey publicKey, ByteArray signedBytes, ByteArray signatureBytes, COSEAlgorithmIdentifier alg) {
        try {
            Signature signature = Signature.getInstance(WebAuthnCodecs.getJavaAlgorithmName(alg), provider);
            signature.initVerify(publicKey);
            signature.update(signedBytes.getBytes());
            return signature.verify(signatureBytes.getBytes());
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            throw new RuntimeException(String.format("Failed to verify signature. This could be a problem with your JVM environment, or a bug in webauthn-server-core. Public key: %s, signed data: %s , signature: %s", publicKey, signedBytes.getBase64Url(), signatureBytes.getBase64Url()), e);
        }
    }

    public PublicKey decodePublicKey(ByteArray encodedPublicKey) {
        try {
            ECPoint point;
            X9ECParameters curve = SECNamedCurves.getByName((String)"secp256r1");
            try {
                point = curve.getCurve().decodePoint(encodedPublicKey.getBytes());
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Could not parse user public key: " + encodedPublicKey.getBase64Url(), e);
            }
            return KeyFactory.getInstance("ECDSA", provider).generatePublic((KeySpec)new ECPublicKeySpec(point, new ECParameterSpec(curve.getCurve(), curve.getG(), curve.getN(), curve.getH())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Failed to decode public key: " + encodedPublicKey.getBase64Url(), e);
        }
    }

    public ByteArray hash(ByteArray bytes) {
        try {
            return new ByteArray(MessageDigest.getInstance("SHA-256", provider).digest(bytes.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteArray hash(String str) {
        return this.hash(new ByteArray(str.getBytes()));
    }
}

