/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.spiderman.utils;

import android.util.Log;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class Logger {
    private static boolean mIsLogEnabled = false;
    private static long sLastTimeStamp = 0L;
    private static final ThreadLocal<SimpleDateFormat> sDateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private static String getTag(String string) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = sDateFormatter.get().format(new Date(System.currentTimeMillis()));
        objectArray[1] = Thread.currentThread().getName();
        objectArray[2] = string;
        return String.format(":Spider:%s:(%s):%s:", objectArray2);
    }

    private static String getMessage(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            try {
                return String.format(string, objectArray);
            }
            catch (Throwable throwable) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder(string);
                for (Object object : objectArray) {
                    stringBuilder2.append(", ").append(object);
                }
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("\n").append(Log.getStackTraceString((Throwable)throwable));
                return stringBuilder3.toString();
            }
        }
        return string;
    }

    public static boolean isLogEnabled() {
        return mIsLogEnabled;
    }

    public static void setLogEnabled(boolean bl) {
        mIsLogEnabled = bl;
    }

    public static int i(String string, String string2, Object ... objectArray) {
        return Logger.isLogEnabled() ? Log.i((String)Logger.getTag(string), (String)Logger.getMessage(string2, objectArray)) : 0;
    }

    public static int d(String string, String string2, Object ... objectArray) {
        return Logger.isLogEnabled() ? Log.d((String)Logger.getTag(string), (String)Logger.getMessage(string2, objectArray)) : 0;
    }

    public static int dc(String string, String string2, Object ... objectArray) {
        string = Logger.getTag(string);
        string2 = Logger.getMessage(string2, objectArray);
        return Logger.isLogEnabled() ? Log.d((String)string, (String)string2) : 0;
    }

    public static int v(String string, String string2, Object ... objectArray) {
        return Logger.isLogEnabled() ? Log.v((String)Logger.getTag(string), (String)Logger.getMessage(string2, objectArray)) : 0;
    }

    public static int e(String string, String string2, Object ... objectArray) {
        return Logger.isLogEnabled() ? Log.e((String)Logger.getTag(string), (String)Logger.getMessage(string2, objectArray)) : 0;
    }

    public static int w(String string, String string2, Object ... objectArray) {
        return Logger.isLogEnabled() ? Log.w((String)Logger.getTag(string), (String)Logger.getMessage(string2, objectArray)) : 0;
    }

    public static int e(String string, Throwable throwable) {
        return Logger.isLogEnabled() ? Log.e((String)Logger.getTag(string), (String)Log.getStackTraceString((Throwable)throwable)) : 0;
    }

    public static int e(String charSequence, Throwable throwable, String string, Object ... objectArray) {
        int n2;
        if (Logger.isLogEnabled()) {
            StringBuilder stringBuilder;
            String string2 = Logger.getTag(charSequence);
            charSequence = stringBuilder;
            ((StringBuilder)charSequence)();
            n2 = Log.e((String)string2, (String)stringBuilder.append(Logger.getMessage(string, objectArray)).append("\n").append(Log.getStackTraceString((Throwable)throwable)).toString());
        } else {
            n2 = 0;
        }
        return n2;
    }

    public static int t(String string, String string2, Object ... objectArray) {
        if (Logger.isLogEnabled()) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - sLastTimeStamp;
            string = Logger.getTag(string);
            StringBuilder stringBuilder = new StringBuilder().append("").append(l2);
            String string3 = sLastTimeStamp > 0L ? " (+" + l3 + "ms) " : " ";
            sLastTimeStamp = l2;
            return Log.d((String)string, (String)stringBuilder.append(string3).append(Logger.getMessage(string2, objectArray)).toString());
        }
        return 0;
    }

    public static void printStackTrace(String string) {
        if (!Logger.isLogEnabled()) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        Logger.d(string, "\n---------------------", new Object[0]);
        for (int i2 = 3; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            Logger.d(string, "    " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")", new Object[0]);
        }
        Logger.d(string, "---------------------\n", new Object[0]);
    }
}

