/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.spring;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.yomahub.liteflow.spi.ContextAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAware
implements ApplicationContextAware,
ContextAware {
    private static ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public <T> T getBean(String name) {
        try {
            Object t = applicationContext.getBean(name);
            return (T)t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T getBean(Class<T> clazz) {
        try {
            Object t = applicationContext.getBean(clazz);
            return (T)t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T registerBean(String beanName, Class<T> c) {
        try {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClassName(c.getName());
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            return this.getBean(beanName);
        }
        catch (Exception e) {
            return (T)ReflectUtil.newInstance(c, (Object[])new Object[0]);
        }
    }

    public <T> T registerBean(Class<T> c) {
        return this.registerBean(c.getName(), c);
    }

    public <T> T registerOrGet(String beanName, Class<T> clazz) {
        if (ObjectUtil.isNull((Object)applicationContext)) {
            return null;
        }
        T t = this.getBean(clazz);
        if (ObjectUtil.isNull(t)) {
            t = this.registerBean(beanName, clazz);
        }
        return t;
    }

    public int priority() {
        return 1;
    }
}

