/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.process.impl;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.process.LiteflowScannerProcessStep;
import com.yomahub.liteflow.process.context.LiteflowScannerProcessStepContext;
import com.yomahub.liteflow.process.enums.LiteflowScannerProcessStepEnum;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.annotation.ScriptBean;
import com.yomahub.liteflow.script.proxy.ScriptBeanProxy;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptBeanProcess
implements LiteflowScannerProcessStep {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptBeanProcess.class);

    @Override
    public boolean filter(LiteflowScannerProcessStepContext ctx) {
        Class clazz = ctx.getClazz();
        ScriptBean outPut = (ScriptBean)AnnotationUtil.getAnnotationAlias((AnnotatedElement)clazz, ScriptBean.class);
        ctx.setOutPut(outPut);
        return ObjectUtil.isNotNull((Object)outPut);
    }

    @Override
    public Object postProcessAfterInitialization(LiteflowScannerProcessStepContext ctx) {
        Class clazz = ctx.getClazz();
        String beanName = ctx.getBeanName();
        Object bean = ctx.getBean();
        ScriptBean scriptBean = (ScriptBean)ctx.getOutPut();
        LOG.info("script bean[{}] has been found", (Object)beanName);
        ScriptBeanProxy proxy = new ScriptBeanProxy(bean, clazz, scriptBean);
        ScriptBeanManager.addScriptBean((String)scriptBean.value(), (Object)proxy.getProxyScriptBean());
        return bean;
    }

    @Override
    public LiteflowScannerProcessStepEnum type() {
        return LiteflowScannerProcessStepEnum.SCRIPT_BEAN;
    }
}

