/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read.impl;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.AbstractSqlRead;
import com.yomahub.liteflow.parser.sql.read.vo.ScriptVO;
import com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ScriptRead
extends AbstractSqlRead<ScriptVO> {
    public ScriptRead(SQLParserVO config) {
        super(config);
    }

    @Override
    protected ScriptVO parse(ResultSet rs) throws SQLException {
        ScriptVO scriptVO = new ScriptVO();
        scriptVO.setNodeId(this.getStringFromRsWithCheck(rs, this.config.getScriptIdField()));
        scriptVO.setName(this.getStringFromRs(rs, this.config.getScriptNameField()));
        scriptVO.setType(this.getStringFromRsWithCheck(rs, this.config.getScriptTypeField()));
        scriptVO.setLanguage(this.getStringFromRs(rs, this.config.getScriptLanguageField()));
        scriptVO.setScript(this.getStringFromRsWithCheck(rs, this.config.getScriptDataField()));
        return scriptVO;
    }

    @Override
    public boolean hasEnableFiled() {
        String scriptEnableField = this.config.getScriptEnableField();
        return StrUtil.isNotBlank((CharSequence)scriptEnableField);
    }

    @Override
    public boolean getEnableFiledValue(ResultSet rs) throws SQLException {
        String scriptEnableField = this.config.getScriptEnableField();
        byte enable = rs.getByte(scriptEnableField);
        return enable == 1;
    }

    @Override
    public String buildQuerySql() {
        if (StringUtils.isNotBlank((String)this.config.getScriptCustomSql())) {
            return this.config.getScriptCustomSql();
        }
        String scriptTableName = this.config.getScriptTableName();
        String scriptApplicationNameField = this.config.getScriptApplicationNameField();
        String applicationName = this.config.getApplicationName();
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}'", (Object[])new Object[]{scriptTableName, scriptApplicationNameField, applicationName});
    }

    @Override
    public String buildQuerySql(String scriptNodeId) {
        if (StringUtils.isNotBlank((String)this.config.getScriptCustomSql())) {
            return this.config.getScriptCustomSql();
        }
        String scriptTableName = this.config.getScriptTableName();
        String scriptApplicationNameField = this.config.getScriptApplicationNameField();
        String applicationName = this.config.getApplicationName();
        String scriptIdField = this.config.getScriptIdField();
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}' and  {}='{}'", (Object[])new Object[]{scriptTableName, scriptApplicationNameField, applicationName, scriptIdField, scriptNodeId});
    }

    @Override
    public void checkConfig() {
        String scriptTableName = this.config.getScriptTableName();
        String scriptIdField = this.config.getScriptIdField();
        String scriptDataField = this.config.getScriptDataField();
        String scriptTypeField = this.config.getScriptTypeField();
        String scriptApplicationNameField = this.config.getScriptApplicationNameField();
        if (StrUtil.isBlank((CharSequence)scriptTableName)) {
            throw new ELSQLException("You did not define the scriptTableName property");
        }
        if (StrUtil.isBlank((CharSequence)scriptIdField)) {
            throw new ELSQLException("You did not define the scriptIdField property");
        }
        if (StrUtil.isBlank((CharSequence)scriptDataField)) {
            throw new ELSQLException("You did not define the scriptDataField property");
        }
        if (StrUtil.isBlank((CharSequence)scriptTypeField)) {
            throw new ELSQLException("You did not define the scriptTypeField property");
        }
        if (StrUtil.isBlank((CharSequence)scriptApplicationNameField)) {
            throw new ELSQLException("You did not define the scriptApplicationNameField property");
        }
    }

    @Override
    public boolean needRead() {
        if (StrUtil.isBlank((CharSequence)this.config.getScriptTableName())) {
            return false;
        }
        String sqlCmd = StrUtil.format((CharSequence)"SELECT 1 FROM {} ", (Object[])new Object[]{this.config.getScriptTableName()});
        Connection conn = LiteFlowJdbcUtil.getConn(this.config);
        return LiteFlowJdbcUtil.checkConnectionCanExecuteSql(conn, sqlCmd);
    }

    @Override
    public ReadType type() {
        return ReadType.SCRIPT;
    }

    private boolean withLanguage() {
        return StrUtil.isNotBlank((CharSequence)this.config.getScriptLanguageField());
    }
}

