/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yomahub.liteflow.exception.JsonProcessException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull((Object)object)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while writing value as string[{}],reason: {}", (Object[])new Object[]{object.getClass().getName(), e.getMessage()});
            LOG.error(e.getMessage(), (Throwable)e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static JsonNode parseObject(String text) {
        if (StrUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return objectMapper.readTree(text);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while parsing text [{}],reason: {}", (Object[])new Object[]{text, e.getMessage()});
            LOG.error(e.getMessage(), (Throwable)e);
            throw new JsonProcessException(errMsg);
        }
    }
}

