/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.factory;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.exception.ErrorSupportPathException;
import com.yomahub.liteflow.parser.ClassJsonFlowParser;
import com.yomahub.liteflow.parser.ClassXmlFlowParser;
import com.yomahub.liteflow.parser.ClassYmlFlowParser;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.el.ClassJsonFlowELParser;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.el.ClassYmlFlowELParser;
import com.yomahub.liteflow.parser.factory.ClassParserFactory;
import com.yomahub.liteflow.parser.factory.FlowParserFactory;
import com.yomahub.liteflow.parser.factory.LocalParserFactory;
import com.yomahub.liteflow.parser.factory.ZookeeperParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowParserProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FlowExecutor.class);
    private static final String LOCAL_XML_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.xml$";
    private static final String LOCAL_JSON_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.json$";
    private static final String LOCAL_YML_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.yml$";
    private static final String LOCAL_EL_XML_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.el\\.xml$";
    private static final String LOCAL_EL_JSON_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.el\\.json$";
    private static final String LOCAL_EL_YML_CONFIG_REGEX = "^[\\w\\:\\-\\@\\/\\\\\\*]+\\.el\\.yml$";
    private static final String FORMAT_EL_XML_CONFIG_REGEX = "el_xml:.+";
    private static final String FORMAT_EL_JSON_CONFIG_REGEX = "el_json:.+";
    private static final String FORMAT_EL_YML_CONFIG_REGEX = "el_yml:.+";
    private static final String FORMAT_XML_CONFIG_REGEX = "xml:.+";
    private static final String FORMAT_JSON_CONFIG_REGEX = "json:.+";
    private static final String FORMAT_YML_CONFIG_REGEX = "yml:.+";
    private static final String PREFIX_FORMAT_CONFIG_REGEX = "xml:|json:|yml:|el_xml:|el_json:|el_yml:";
    private static final String CLASS_CONFIG_REGEX = "^(xml:|json:|yml:|el_xml:|el_json:|el_yml:)?\\w+(\\.\\w+)*$";
    private static final String ZK_CONFIG_REGEX = "(xml:|json:|yml:|el_xml:|el_json:|el_yml:)?[\\w\\d][\\w\\d\\.]+\\:(\\d)+(\\,[\\w\\d][\\w\\d\\.]+\\:(\\d)+)*";

    public static FlowParser lookup(String path) throws Exception {
        FlowParserFactory factory;
        if (FlowParserProvider.isLocalConfig(path)) {
            factory = new LocalParserFactory();
            if (ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_XML.getType());
                return factory.createXmlParser(path);
            }
            if (ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_JSON.getType());
                return factory.createJsonParser(path);
            }
            if (ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_YML.getType());
                return factory.createYmlParser(path);
            }
            if (ReUtil.isMatch((String)LOCAL_EL_XML_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local EL file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_XML.getType());
                return factory.createXmlELParser(path);
            }
            if (ReUtil.isMatch((String)LOCAL_EL_JSON_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local EL file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_JSON.getType());
                return factory.createJsonELParser(path);
            }
            if (ReUtil.isMatch((String)LOCAL_EL_YML_CONFIG_REGEX, (CharSequence)path)) {
                LOG.info("flow info loaded from local EL file,path={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_YML.getType());
                return factory.createYmlELParser(path);
            }
        } else {
            if (FlowParserProvider.isClassConfig(path)) {
                String className = ReUtil.replaceAll((CharSequence)path, (String)PREFIX_FORMAT_CONFIG_REGEX, (String)"");
                ClassParserFactory factory2 = new ClassParserFactory();
                Class<?> clazz = Class.forName(className);
                if (ClassXmlFlowParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_XML.getType());
                    return factory2.createXmlParser(className);
                }
                if (ClassJsonFlowParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_JSON.getType());
                    return factory2.createJsonParser(className);
                }
                if (ClassYmlFlowParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_YML.getType());
                    return factory2.createYmlParser(className);
                }
                if (ClassXmlFlowELParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config with el,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_EL_XML.getType());
                    return factory2.createXmlELParser(className);
                }
                if (ClassJsonFlowELParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config with el,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_EL_JSON.getType());
                    return factory2.createJsonELParser(className);
                }
                if (ClassYmlFlowELParser.class.isAssignableFrom(clazz)) {
                    LOG.info("flow info loaded from class config with el,class={},format type={}", (Object)className, (Object)FlowParserTypeEnum.TYPE_EL_YML.getType());
                    return factory2.createYmlELParser(className);
                }
                String errorMsg = StrUtil.format((CharSequence)"can't support the format {}", (Object[])new Object[]{path});
                throw new ErrorSupportPathException(errorMsg);
            }
            if (FlowParserProvider.isZKConfig(path)) {
                factory = new ZookeeperParserFactory();
                if (ReUtil.isMatch((String)FORMAT_XML_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_XML.getType());
                    return factory.createXmlParser(path);
                }
                if (ReUtil.isMatch((String)FORMAT_JSON_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_JSON.getType());
                    return factory.createJsonParser(path);
                }
                if (ReUtil.isMatch((String)FORMAT_YML_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_YML.getType());
                    return factory.createYmlParser(path);
                }
                if (ReUtil.isMatch((String)FORMAT_EL_XML_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper with el,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_XML.getType());
                    return factory.createXmlELParser(path);
                }
                if (ReUtil.isMatch((String)FORMAT_EL_YML_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper with el,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_YML.getType());
                    return factory.createYmlELParser(path);
                }
                if (ReUtil.isMatch((String)FORMAT_EL_JSON_CONFIG_REGEX, (CharSequence)path)) {
                    LOG.info("flow info loaded from Zookeeper with el,zkNode={},format type={}", (Object)path, (Object)FlowParserTypeEnum.TYPE_EL_JSON.getType());
                    return factory.createJsonELParser(path);
                }
            }
        }
        String errorMsg = StrUtil.format((CharSequence)"can't find the parser for path:{}", (Object[])new Object[]{path});
        throw new ErrorSupportPathException(errorMsg);
    }

    private static boolean isLocalConfig(String path) {
        return ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_EL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_EL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_EL_YML_CONFIG_REGEX, (CharSequence)path);
    }

    private static boolean isClassConfig(String path) {
        return ReUtil.isMatch((String)CLASS_CONFIG_REGEX, (CharSequence)path);
    }

    private static boolean isZKConfig(String path) {
        return ReUtil.isMatch((String)ZK_CONFIG_REGEX, (CharSequence)path);
    }
}

