/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.base;

import com.yomahub.liteflow.parser.ZookeeperXmlFlowParser;
import com.yomahub.liteflow.parser.base.BaseXmlFlowParser;
import com.yomahub.liteflow.parser.helper.ZkParserHelper;
import java.util.List;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseZookeeperXmlFlowParser
extends BaseXmlFlowParser {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperXmlFlowParser.class);
    private final String nodePath;
    private final ZkParserHelper zkParserHelper;

    public BaseZookeeperXmlFlowParser(String node) {
        this.nodePath = node;
        Consumer<String> parseConsumer = t -> {
            try {
                this.parse((String)t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.zkParserHelper = new ZkParserHelper(this.nodePath, parseConsumer);
    }

    @Override
    public void parseMain(List<String> pathList) throws Exception {
        CuratorFramework client = this.zkParserHelper.getZkCuratorFramework(pathList);
        String content = new String((byte[])client.getData().forPath(this.nodePath));
        this.zkParserHelper.checkContent(content);
        this.parse(content);
        this.zkParserHelper.listenZkNode(client);
    }

    @Override
    public abstract void parseOneChain(Element var1);
}

