/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.collection.CollUtil;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(Chain.class);
    private String chainName;
    private List<Condition> conditionList = new ArrayList<Condition>();
    private List<Condition> preConditionList = new ArrayList<Condition>();
    private List<Condition> finallyConditionList = new ArrayList<Condition>();

    public Chain(String chainName) {
        this.chainName = chainName;
    }

    public Chain() {
    }

    public Chain(String chainName, List<Condition> conditionList) {
        this.chainName = chainName;
        this.conditionList = conditionList;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    @Override
    public void execute(Integer slotIndex) throws Exception {
        if (CollUtil.isEmpty(this.conditionList)) {
            throw new FlowSystemException("no conditionList in this chain[" + this.chainName + "]");
        }
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            slot.setChainName(this.chainName);
            this.executePre(slotIndex);
            for (Condition condition : this.conditionList) {
                condition.setCurrChainName(this.chainName);
                condition.execute(slotIndex);
            }
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            slot.setException(e);
            throw e;
        }
        finally {
            this.executeFinally(slotIndex);
        }
    }

    private void executePre(Integer slotIndex) throws Exception {
        for (Condition condition : this.preConditionList) {
            condition.execute(slotIndex);
        }
    }

    private void executeFinally(Integer slotIndex) throws Exception {
        for (Condition condition : this.finallyConditionList) {
            condition.execute(slotIndex);
        }
    }

    @Override
    public ExecuteTypeEnum getExecuteType() {
        return ExecuteTypeEnum.CHAIN;
    }

    @Override
    public String getExecuteName() {
        return this.chainName;
    }

    public List<Condition> getPreConditionList() {
        return this.preConditionList;
    }

    public void setPreConditionList(List<Condition> preConditionList) {
        this.preConditionList = preConditionList;
    }

    public List<Condition> getFinallyConditionList() {
        return this.finallyConditionList;
    }

    public void setFinallyConditionList(List<Condition> finallyConditionList) {
        this.finallyConditionList = finallyConditionList;
    }
}

