/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow;

import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.slot.Slot;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class LiteflowResponse
implements Serializable {
    private static final long serialVersionUID = -2792556188993845048L;
    private boolean success;
    private String code;
    private String message;
    private Exception cause;
    private Slot slot;

    public LiteflowResponse() {
        this(null);
    }

    public LiteflowResponse(Slot slot) {
        if (slot != null && slot.getException() != null) {
            this.success = false;
            this.cause = slot.getException();
            this.message = this.cause.getMessage();
            this.code = this.cause instanceof LiteFlowException ? ((LiteFlowException)this.cause).getCode() : null;
        } else {
            this.success = true;
        }
        this.slot = slot;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Exception getCause() {
        return this.cause;
    }

    public void setCause(Exception cause) {
        this.cause = cause;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public void setSlot(Slot slot) {
        this.slot = slot;
    }

    public <T> T getFirstContextBean() {
        return this.getSlot().getFirstContextBean();
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        return this.getSlot().getContextBean(contextBeanClazz);
    }

    public Map<String, CmpStep> getExecuteSteps() {
        HashMap<String, CmpStep> map = new HashMap<String, CmpStep>();
        this.getSlot().getExecuteSteps().forEach(cmpStep -> map.put(cmpStep.getNodeId(), (CmpStep)cmpStep));
        return map;
    }

    public Queue<CmpStep> getExecuteStepQueue() {
        return this.getSlot().getExecuteSteps();
    }

    public String getExecuteStepStr() {
        return this.getSlot().getExecuteStepStr();
    }

    public String getExecuteStepStrWithoutTime() {
        return this.getSlot().getExecuteStepStr(false);
    }

    public String getRequestId() {
        return this.getSlot().getRequestId();
    }
}

