/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.Operator;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeOperator
extends Operator {
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Object executeInner(Object[] objects) throws Exception {
        if (ArrayUtil.isEmpty((Object[])objects)) {
            throw new Exception();
        }
        if (objects.length != 1) {
            this.LOG.error("parameter error");
            throw new Exception();
        }
        if (!(objects[0] instanceof String)) {
            this.LOG.error("The value must be Node item!");
            throw new Exception();
        }
        String nodeId = (String)objects[0];
        if (FlowBus.containNode(nodeId)) {
            return FlowBus.getNode(nodeId);
        }
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getSubstituteCmpClass())) {
            Node substituteNode = FlowBus.getNodeMap().values().stream().filter(node -> node.getInstance().getClass().getName().equals(liteflowConfig.getSubstituteCmpClass())).findFirst().orElse(null);
            if (ObjectUtil.isNotNull((Object)substituteNode)) {
                return substituteNode;
            }
            String error = StrUtil.format((CharSequence)"This node[{}] cannot be found", (Object[])new Object[]{nodeId});
            this.LOG.error(error);
            throw new Exception();
        }
        String error = StrUtil.format((CharSequence)"This node[{}] cannot be found, or you can configure an substitute node", (Object[])new Object[]{nodeId});
        this.LOG.error(error);
        throw new Exception();
    }
}

