/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.instruction.op.OperatorBase;
import com.yomahub.liteflow.builder.el.operator.AnyOperator;
import com.yomahub.liteflow.builder.el.operator.FinallyOperator;
import com.yomahub.liteflow.builder.el.operator.IdOperator;
import com.yomahub.liteflow.builder.el.operator.IgnoreErrorOperator;
import com.yomahub.liteflow.builder.el.operator.NodeOperator;
import com.yomahub.liteflow.builder.el.operator.PreOperator;
import com.yomahub.liteflow.builder.el.operator.SwitchOperator;
import com.yomahub.liteflow.builder.el.operator.TagOperator;
import com.yomahub.liteflow.builder.el.operator.ThenOperator;
import com.yomahub.liteflow.builder.el.operator.ThreadPoolOperator;
import com.yomahub.liteflow.builder.el.operator.ToOperator;
import com.yomahub.liteflow.builder.el.operator.WhenOperator;
import com.yomahub.liteflow.exception.ELParseException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowChainELBuilder {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private Chain chain = new Chain();
    private final List<Condition> conditionList = new ArrayList<Condition>();
    private final List<Condition> preConditionList = new ArrayList<Condition>();
    private final List<Condition> finallyConditionList = new ArrayList<Condition>();
    private final ExpressRunner expressRunner = new ExpressRunner();

    public static LiteFlowChainELBuilder createChain() {
        return new LiteFlowChainELBuilder();
    }

    public LiteFlowChainELBuilder() {
        this.expressRunner.addFunction("THEN", (OperatorBase)new ThenOperator());
        this.expressRunner.addFunction("WHEN", (OperatorBase)new WhenOperator());
        this.expressRunner.addFunction("SWITCH", (OperatorBase)new SwitchOperator());
        this.expressRunner.addFunction("PRE", (OperatorBase)new PreOperator());
        this.expressRunner.addFunction("FINALLY", (OperatorBase)new FinallyOperator());
        this.expressRunner.addFunctionAndClassMethod("to", Object.class, (OperatorBase)new ToOperator());
        this.expressRunner.addFunctionAndClassMethod("tag", Object.class, (OperatorBase)new TagOperator());
        this.expressRunner.addFunctionAndClassMethod("any", Object.class, (OperatorBase)new AnyOperator());
        this.expressRunner.addFunctionAndClassMethod("id", Object.class, (OperatorBase)new IdOperator());
        this.expressRunner.addFunctionAndClassMethod("ignoreError", Object.class, (OperatorBase)new IgnoreErrorOperator());
        this.expressRunner.addFunctionAndClassMethod("threadPool", Object.class, (OperatorBase)new ThreadPoolOperator());
        this.expressRunner.addFunction("node", (OperatorBase)new NodeOperator());
    }

    public LiteFlowChainELBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainELBuilder setEL(String elStr) {
        if (StrUtil.isBlank((CharSequence)elStr)) {
            String errMsg = StrUtil.format((CharSequence)"no conditionList in this chain[{}]", (Object[])new Object[]{this.chain.getChainName()});
            throw new FlowSystemException(errMsg);
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chain -> context.put((Object)chain.getChainName(), chain));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            Condition condition = (Condition)this.expressRunner.execute(elStr, (IExpressContext)context, errorList, true, true);
            for (Executable executable : condition.getExecutableList()) {
                if (executable instanceof PreCondition) {
                    this.preConditionList.add((PreCondition)executable);
                    continue;
                }
                if (!(executable instanceof FinallyCondition)) continue;
                this.finallyConditionList.add((FinallyCondition)executable);
            }
            this.conditionList.add(condition);
            return this;
        }
        catch (Exception e) {
            for (String scriptErrorMsg : errorList) {
                this.LOG.error("\n{}", (Object)scriptErrorMsg);
            }
            throw new ELParseException(e.getMessage());
        }
    }

    public void build() {
        this.chain.setConditionList(this.conditionList);
        this.chain.setPreConditionList(this.preConditionList);
        this.chain.setFinallyConditionList(this.finallyConditionList);
        this.checkBuild();
        FlowBus.addChain(this.chain);
    }

    private void checkBuild() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.chain.getChainName())) {
            errorList.add("name is blank");
        }
        if (CollUtil.isNotEmpty(errorList)) {
            throw new RuntimeException(CollUtil.join(errorList, (CharSequence)",", (String)"[", (String)"]"));
        }
    }
}

