/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.parser.XmlFlowParser;
import java.text.MessageFormat;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperXmlFlowParser
extends XmlFlowParser {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperXmlFlowParser.class);
    private final String nodePath;

    public ZookeeperXmlFlowParser(String node) {
        this.nodePath = node;
    }

    @Override
    public void parseMain(List<String> pathList) throws Exception {
        String content;
        String path = pathList.get(0);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)path, (RetryPolicy)new RetryNTimes(10, 5000));
        client.start();
        if (client.checkExists().forPath(this.nodePath) == null) {
            client.create().creatingParentsIfNeeded().forPath(this.nodePath, "".getBytes());
        }
        if (StrUtil.isBlank((CharSequence)(content = new String((byte[])client.getData().forPath(this.nodePath))))) {
            String error = MessageFormat.format("the node[{0}] value is empty", this.nodePath);
            throw new ParseException(error);
        }
        this.parse(content);
        NodeCache cache = new NodeCache(client, this.nodePath);
        cache.start();
        cache.getListenable().addListener(() -> {
            String content1 = new String(cache.getCurrentData().getData());
            LOG.info("stating load flow config....");
            this.parse(content1);
        });
    }
}

