/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowWhenConditionBuilder;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.data.ExecutableEntity;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.parser.RegexNodeEntity;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.ArrayList;
import java.util.List;

public class LiteFlowConditionBuilder {
    protected Condition condition = new Condition();

    public static LiteFlowConditionBuilder createCondition(ConditionTypeEnum conditionType) {
        return new LiteFlowConditionBuilder(conditionType);
    }

    public static LiteFlowConditionBuilder createThenCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_THEN);
    }

    public static LiteFlowWhenConditionBuilder createWhenCondition() {
        return new LiteFlowWhenConditionBuilder(ConditionTypeEnum.TYPE_WHEN);
    }

    public static LiteFlowConditionBuilder createPreCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_PRE);
    }

    public static LiteFlowConditionBuilder createFinallyCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_FINALLY);
    }

    public LiteFlowConditionBuilder(ConditionTypeEnum conditionType) {
        this.condition.setConditionType(conditionType);
        this.condition.setNodeList(new ArrayList<Executable>());
    }

    public LiteFlowConditionBuilder setValue(String value) {
        String[] condArray;
        if (StrUtil.isBlank((CharSequence)value)) {
            return this;
        }
        for (String s : condArray = value.split(",")) {
            String itemExpression = s.trim();
            RegexEntity regexEntity = RegexEntity.parse(itemExpression);
            ExecutableEntity executableEntity = this.convertExecutableEntity(regexEntity);
            this.setExecutable(executableEntity);
        }
        return this;
    }

    private ExecutableEntity convertExecutableEntity(RegexEntity regexEntity) {
        RegexNodeEntity item = regexEntity.getItem();
        ExecutableEntity executableEntity = new ExecutableEntity(item.getId(), item.getTag());
        if (ObjectUtil.isNotNull((Object)regexEntity.getRealItemArray())) {
            for (RegexNodeEntity realItem : regexEntity.getRealItemArray()) {
                executableEntity.addNodeCondComponent(new ExecutableEntity(realItem.getId(), realItem.getTag()));
            }
        }
        return executableEntity;
    }

    public LiteFlowConditionBuilder setExecutables(List<ExecutableEntity> executableEntities) {
        if (CollUtil.isEmpty(executableEntities)) {
            return this;
        }
        for (ExecutableEntity conditionNodeEntity : executableEntities) {
            this.setExecutable(conditionNodeEntity);
        }
        return this;
    }

    public LiteFlowConditionBuilder setExecutable(ExecutableEntity executableEntity) {
        if (FlowBus.containNode(executableEntity.getId())) {
            Node node = FlowBus.copyNode(executableEntity.getId());
            node.setTag(executableEntity.getTag());
            this.condition.getNodeList().add(node);
            this.buildCondNode(node, executableEntity.getNodeCondComponents());
        } else if (this.hasChain(executableEntity.getId())) {
            Chain chain = FlowBus.getChain(executableEntity.getId());
            this.condition.getNodeList().add(chain);
        } else {
            NodeComponent nodeComponent = (NodeComponent)ContextAwareHolder.loadContextAware().getBean(executableEntity.getId());
            if (ObjectUtil.isNotNull((Object)nodeComponent)) {
                FlowBus.addSpringScanNode(executableEntity.getId(), nodeComponent);
                this.setExecutable(executableEntity);
            } else {
                String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{executableEntity.getId()});
                throw new ExecutableItemNotFoundException(errorMsg);
            }
        }
        return this;
    }

    private void buildCondNode(Node node, List<ExecutableEntity> executableEntities) {
        if (CollUtil.isEmpty(executableEntities)) {
            return;
        }
        for (ExecutableEntity realItem : executableEntities) {
            if (FlowBus.containNode(realItem.getId())) {
                Node condNode = FlowBus.copyNode(realItem.getId());
                condNode.setTag(realItem.getTag());
                node.setCondNode(condNode.getId(), condNode);
                continue;
            }
            if (this.hasChain(realItem.getId())) {
                Chain chain = FlowBus.getChain(realItem.getId());
                node.setCondNode(chain.getChainName(), chain);
                continue;
            }
            String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{realItem.getId()});
            throw new ExecutableItemNotFoundException(errorMsg);
        }
    }

    public Condition build() {
        return this.condition;
    }

    private boolean hasChain(String chainId) {
        return FlowBus.containChain(chainId);
    }
}

