/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowChainBuilder;
import com.yomahub.liteflow.builder.LiteFlowConditionBuilder;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.EmptyConditionValueException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.exception.NotSupportConditionException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.spi.holder.ContextCmpInitHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlFlowParser
implements FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(XmlFlowParser.class);

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList documentList = ListUtil.toList((Object[])new Document[0]);
        for (String content : contentList) {
            Document document = DocumentHelper.parseText((String)content);
            documentList.add(document);
        }
        this.parseDocument(documentList);
    }

    public void parseDocument(List<Document> documentList) throws Exception {
        ContextCmpInitHolder.loadContextCmpInit().initCmp();
        documentList.forEach(document -> {
            List chainList = document.getRootElement().elements("chain");
            chainList.forEach(e -> FlowBus.addChain(e.attributeValue("name")));
        });
        for (Document document2 : documentList) {
            Element rootElement = document2.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (ObjectUtil.isNotNull((Object)nodesElement)) {
                List nodeList = nodesElement.elements("node");
                for (Element e : nodeList) {
                    NodeTypeEnum nodeTypeEnum;
                    String id = e.attributeValue("id");
                    String name = e.attributeValue("name");
                    String clazz = e.attributeValue("class");
                    String type = e.attributeValue("type");
                    String script = e.getTextTrim();
                    String file = e.attributeValue("file");
                    if (StrUtil.isBlank((CharSequence)type)) {
                        type = NodeTypeEnum.COMMON.getCode();
                    }
                    if (ObjectUtil.isNull((Object)((Object)(nodeTypeEnum = NodeTypeEnum.getEnumByCode(type))))) {
                        throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
                    }
                    LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).build();
                }
            }
            List chainList = rootElement.elements("chain");
            chainList.forEach(this::parseOneChain);
        }
    }

    private void parseOneChain(Element e) {
        String chainName = e.attributeValue("name");
        LiteFlowChainBuilder chainBuilder = LiteFlowChainBuilder.createChain().setChainName(chainName);
        Iterator it = e.elementIterator();
        while (it.hasNext()) {
            Element condE = (Element)it.next();
            ConditionTypeEnum conditionType = ConditionTypeEnum.getEnumByCode(condE.getName());
            String condValueStr = condE.attributeValue("value");
            String errorResume = condE.attributeValue("errorResume");
            String group = condE.attributeValue("group");
            String any = condE.attributeValue("any");
            String threadExecutorClass = condE.attributeValue("threadExecutorClass");
            if (ObjectUtil.isNull((Object)((Object)conditionType))) {
                throw new NotSupportConditionException("ConditionType is not supported");
            }
            if (StrUtil.isBlank((CharSequence)condValueStr)) {
                throw new EmptyConditionValueException("Condition value cannot be empty");
            }
            if (conditionType.equals((Object)ConditionTypeEnum.TYPE_WHEN)) {
                chainBuilder.setCondition(LiteFlowConditionBuilder.createWhenCondition().setErrorResume(errorResume).setGroup(group).setAny(any).setThreadExecutorClass(threadExecutorClass).setValue(condValueStr).build()).build();
                continue;
            }
            chainBuilder.setCondition(LiteFlowConditionBuilder.createCondition(conditionType).setValue(condValueStr).build()).build();
        }
    }
}

