/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.data;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBus {
    private static final Logger LOG = LoggerFactory.getLogger(DataBus.class);
    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Slot> SLOTS;
    private static ConcurrentLinkedQueue<Integer> QUEUE;
    private static Integer currentIndexMaxValue;

    public static void init() {
        if (MapUtil.isEmpty(SLOTS)) {
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            currentIndexMaxValue = liteflowConfig.getSlotSize();
            SLOTS = new ConcurrentHashMap();
            QUEUE = IntStream.range(0, currentIndexMaxValue).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int offerSlot(Class<? extends Slot> slotClazz) {
        try {
            Slot slot = slotClazz.newInstance();
            Integer slotIndex = QUEUE.poll();
            if (ObjectUtil.isNull((Object)slotIndex)) {
                Class<DataBus> clazz = DataBus.class;
                // MONITORENTER : com.yomahub.liteflow.entity.data.DataBus.class
                slotIndex = QUEUE.poll();
                if (ObjectUtil.isNull((Object)slotIndex)) {
                    int nextMaxIndex = (int)Math.round((double)currentIndexMaxValue.intValue() * 1.75);
                    QUEUE.addAll(IntStream.range(currentIndexMaxValue, nextMaxIndex).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new)));
                    currentIndexMaxValue = nextMaxIndex;
                    slotIndex = QUEUE.poll();
                }
                // MONITOREXIT : clazz
            }
            if (!ObjectUtil.isNotNull((Object)slotIndex)) return -1;
            SLOTS.put(slotIndex, slot);
            OCCUPY_COUNT.incrementAndGet();
            return slotIndex;
        }
        catch (Exception e) {
            LOG.error("offer slot error", (Throwable)e);
            return -1;
        }
    }

    public static <T extends Slot> T getSlot(int slotIndex) {
        return (T)SLOTS.get(slotIndex);
    }

    public static void releaseSlot(int slotIndex) {
        if (ObjectUtil.isNotNull((Object)SLOTS.get(slotIndex))) {
            LOG.info("[{}]:slot[{}] released", (Object)SLOTS.get(slotIndex).getRequestId(), (Object)slotIndex);
            SLOTS.remove(slotIndex);
            QUEUE.add(slotIndex);
            OCCUPY_COUNT.decrementAndGet();
        } else {
            LOG.warn("slot[{}] already has been released", (Object)slotIndex);
        }
    }
}

