/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.entity.data;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.entity.data.CmpStep;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.exception.NullParamException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsSlot
implements Slot {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private static final String REQUEST = "_request";
    private static final String RESPONSE = "_response";
    private static final String CHAIN_NAME = "_chain_name";
    private static final String COND_NODE_PREFIX = "_cond_";
    private static final String NODE_INPUT_PREFIX = "_input_";
    private static final String NODE_OUTPUT_PREFIX = "_output_";
    private static final String CHAIN_REQ_PREFIX = "_chain_req_";
    private static final String REQUEST_ID = "_req_id";
    private static final String EXCEPTION = "_exception";
    private static final String PRIVATE_DELIVERY_PREFIX = "_private_d_";
    private final Queue<CmpStep> executeSteps = new ConcurrentLinkedQueue<CmpStep>();
    private String executeStepsStr;
    protected ConcurrentHashMap<String, Object> dataMap = new ConcurrentHashMap();

    private <T> void putDataMap(String key, T t) {
        if (ObjectUtil.isNull(t)) {
            throw new NullParamException("data slot can't accept null param");
        }
        this.dataMap.put(key, t);
    }

    @Override
    public <T> T getInput(String nodeId) {
        return (T)this.dataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    @Override
    public <T> T getOutput(String nodeId) {
        return (T)this.dataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    @Override
    public <T> void setInput(String nodeId, T t) {
        this.putDataMap(NODE_INPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> void setOutput(String nodeId, T t) {
        this.putDataMap(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    @Override
    public <T> T getRequestData() {
        return (T)this.dataMap.get(REQUEST);
    }

    @Override
    public <T> void setRequestData(T t) {
        this.putDataMap(REQUEST, t);
    }

    @Override
    public <T> T getResponseData() {
        return (T)this.dataMap.get(RESPONSE);
    }

    @Override
    public <T> void setResponseData(T t) {
        this.putDataMap(RESPONSE, t);
    }

    @Override
    public <T> T getChainReqData(String chainId) {
        return (T)this.dataMap.get(CHAIN_REQ_PREFIX + chainId);
    }

    @Override
    public <T> void setChainReqData(String chainId, T t) {
        this.putDataMap(CHAIN_REQ_PREFIX + chainId, t);
    }

    @Override
    public boolean hasData(String key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public <T> T getData(String key) {
        return (T)this.dataMap.get(key);
    }

    @Override
    public <T> void setData(String key, T t) {
        this.putDataMap(key, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setPrivateDeliveryData(String nodeId, T t) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        AbsSlot absSlot = this;
        synchronized (absSlot) {
            if (this.dataMap.containsKey(privateDKey)) {
                Queue queue = (Queue)this.dataMap.get(privateDKey);
                queue.add(t);
            } else {
                ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
                queue.add(t);
                this.setData(privateDKey, queue);
            }
        }
    }

    public <T> Queue<T> getPrivateDeliveryQueue(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.dataMap.containsKey(privateDKey)) {
            return (Queue)this.dataMap.get(privateDKey);
        }
        return null;
    }

    @Override
    public <T> T getPrivateDeliveryData(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.dataMap.containsKey(privateDKey)) {
            Queue queue = (Queue)this.dataMap.get(privateDKey);
            return (T)queue.poll();
        }
        return null;
    }

    @Override
    public <T> void setCondResult(String key, T t) {
        this.putDataMap(COND_NODE_PREFIX + key, t);
    }

    @Override
    public <T> T getCondResult(String key) {
        return (T)this.dataMap.get(COND_NODE_PREFIX + key);
    }

    @Override
    public void setChainName(String chainName) {
        this.putDataMap(CHAIN_NAME, chainName);
    }

    @Override
    public String getChainName() {
        return (String)this.dataMap.get(CHAIN_NAME);
    }

    @Override
    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    @Override
    public String getExecuteStepStr() {
        StringBuilder str = new StringBuilder();
        Iterator it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = (CmpStep)it.next();
            str.append(cmpStep);
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    @Override
    public void printStep() {
        if (ObjectUtil.isNull((Object)this.executeStepsStr)) {
            this.executeStepsStr = this.getExecuteStepStr();
        }
        LOG.info("[{}]:CHAIN_NAME[{}]\n{}", new Object[]{this.getRequestId(), this.getChainName(), this.executeStepsStr});
    }

    @Override
    public void generateRequestId() {
        this.dataMap.put(REQUEST_ID, IdUtil.nanoId());
    }

    @Override
    public String getRequestId() {
        return (String)this.dataMap.get(REQUEST_ID);
    }

    public Queue<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    @Override
    public Exception getException() {
        return (Exception)this.dataMap.get(EXCEPTION);
    }

    @Override
    public void setException(Exception e) {
        this.putDataMap(EXCEPTION, e);
    }
}

