/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowWhenConditionBuilder;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Condition;
import com.yomahub.liteflow.entity.flow.Executable;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ExecutableItemNotFoundException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.RegexEntity;
import com.yomahub.liteflow.parser.RegexNodeEntity;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.ArrayList;

public class LiteFlowConditionBuilder {
    protected Condition condition = new Condition();

    public static LiteFlowConditionBuilder createCondition(ConditionTypeEnum conditionType) {
        return new LiteFlowConditionBuilder(conditionType);
    }

    public static LiteFlowConditionBuilder createThenCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_THEN);
    }

    public static LiteFlowWhenConditionBuilder createWhenCondition() {
        return new LiteFlowWhenConditionBuilder(ConditionTypeEnum.TYPE_WHEN);
    }

    public static LiteFlowConditionBuilder createPreCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_PRE);
    }

    public static LiteFlowConditionBuilder createFinallyCondition() {
        return new LiteFlowConditionBuilder(ConditionTypeEnum.TYPE_FINALLY);
    }

    public LiteFlowConditionBuilder(ConditionTypeEnum conditionType) {
        this.condition.setConditionType(conditionType);
        this.condition.setNodeList(new ArrayList<Executable>());
    }

    public LiteFlowConditionBuilder setValue(String value) {
        String[] condArray;
        if (StrUtil.isBlank((CharSequence)value)) {
            return this;
        }
        for (String s : condArray = value.split(",")) {
            String itemExpression = s.trim();
            RegexEntity regexEntity = RegexEntity.parse(itemExpression);
            RegexNodeEntity item = regexEntity.getItem();
            if (FlowBus.containNode(item.getId())) {
                Node node = FlowBus.copyNode(item.getId());
                node.setTag(regexEntity.getItem().getTag());
                this.condition.getNodeList().add(node);
                if (!ObjectUtil.isNotNull((Object)regexEntity.getRealItemArray())) continue;
                for (RegexNodeEntity realItem : regexEntity.getRealItemArray()) {
                    if (FlowBus.containNode(realItem.getId())) {
                        Node condNode = FlowBus.copyNode(realItem.getId());
                        condNode.setTag(realItem.getTag());
                        node.setCondNode(condNode.getId(), condNode);
                        continue;
                    }
                    if (this.hasChain(realItem.getId())) {
                        Chain chain = FlowBus.getChain(realItem.getId());
                        node.setCondNode(chain.getChainName(), chain);
                        continue;
                    }
                    String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{realItem.getId()});
                    throw new ExecutableItemNotFoundException(errorMsg);
                }
                continue;
            }
            if (this.hasChain(item.getId())) {
                Chain chain = FlowBus.getChain(item.getId());
                this.condition.getNodeList().add(chain);
                continue;
            }
            NodeComponent nodeComponent = (NodeComponent)ContextAwareHolder.loadContextAware().getBean(item.getId());
            if (ObjectUtil.isNotNull((Object)nodeComponent)) {
                FlowBus.addSpringScanNode(item.getId(), nodeComponent);
                this.setValue(item.getId());
                continue;
            }
            String errorMsg = StrUtil.format((CharSequence)"executable node[{}] is not found!", (Object[])new Object[]{regexEntity.getItem().getId()});
            throw new ExecutableItemNotFoundException(errorMsg);
        }
        return this;
    }

    public Condition build() {
        return this.condition;
    }

    private boolean hasChain(String chainId) {
        return FlowBus.containChain(chainId);
    }
}

