/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoForNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;

public class ForCondition
extends LoopCondition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        Node forNode = this.getForNode();
        if (ObjectUtil.isNull((Object)forNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no for-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoForNodeException(errorInfo);
        }
        if (!this.getForNode().isAccess(slotIndex)) {
            return;
        }
        forNode.setCurrChainId(this.getCurrChainId());
        forNode.execute(slotIndex);
        int forCount = (Integer)forNode.getItemResultMetaValue(slotIndex);
        Executable executableItem = this.getDoExecutor();
        Executable breakItem = this.getBreakItem();
        for (int i = 0; i < forCount; ++i) {
            executableItem.setCurrChainId(this.getCurrChainId());
            this.setLoopIndex(executableItem, i);
            executableItem.execute(slotIndex);
            if (!ObjectUtil.isNotNull((Object)breakItem)) continue;
            breakItem.setCurrChainId(this.getCurrChainId());
            this.setLoopIndex(breakItem, i);
            breakItem.execute(slotIndex);
            boolean isBreak = (Boolean)breakItem.getItemResultMetaValue(slotIndex);
            if (isBreak) break;
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_FOR;
    }

    public Node getForNode() {
        return (Node)this.getExecutableOne("FOR_KEY");
    }

    public void setForNode(Node forNode) {
        this.addExecutable("FOR_KEY", forNode);
    }
}

