/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static String[] mergeRepeat(String[] parents, String[] children, boolean ignoreCap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])parents)) {
            for (String parent : parents) {
                map.put(ignoreCap ? parent.toLowerCase() : parent, parent);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])children)) {
            for (String child : children) {
                map.put(ignoreCap ? child.toLowerCase() : child, child);
            }
        }
        Collection values = map.values();
        return values.toArray(new String[0]);
    }

    public static void parseMimeType(String rawdata) {
        String subType;
        String primaryType;
        int slashIndex = rawdata.indexOf(47);
        int semIndex = rawdata.indexOf(59);
        if (slashIndex < 0 && semIndex < 0) {
            throw new RuntimeException("Unable to find a sub type.");
        }
        if (slashIndex < 0 && semIndex >= 0) {
            throw new RuntimeException("Unable to find a sub type.");
        }
        if (slashIndex >= 0 && semIndex < 0) {
            primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            subType = rawdata.substring(slashIndex + 1).trim().toLowerCase(Locale.ENGLISH);
        } else {
            if (slashIndex >= semIndex) {
                throw new RuntimeException("Unable to find a sub type.");
            }
            primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            subType = rawdata.substring(slashIndex + 1, semIndex).trim().toLowerCase(Locale.ENGLISH);
        }
        if (!Utils.isValidToken(primaryType)) {
            throw new RuntimeException("Primary type is invalid.");
        }
        if (!Utils.isValidToken(subType)) {
            throw new RuntimeException("Sub type is invalid.");
        }
    }

    private static boolean isValidToken(String s) {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (Utils.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && "()<>@,;:/[]?=\\\"".indexOf(c) < 0;
    }
}

