/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor.mapping;

import com.yanzhenjie.andserver.annotation.RequestMethod;
import com.yanzhenjie.andserver.processor.mapping.Mapping;
import com.yanzhenjie.andserver.processor.util.Utils;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class Merge
implements Mapping {
    private String[] mPaths;
    private String[] mMethods;
    private String[] mParams;
    private String[] mHeaders;
    private String[] mConsumes;
    private String[] mProduces;
    private Mapping mParent;
    private Mapping mChild;

    public Merge(Mapping parent, Mapping child) {
        this.mParent = parent;
        this.mChild = child;
    }

    @Override
    public String[] value() {
        return this.path();
    }

    @Override
    public String[] path() {
        Object[] cPaths;
        if (this.mPaths != null) {
            return this.mPaths;
        }
        Object[] pPaths = this.mParent.path();
        if (ArrayUtils.isEmpty((Object[])pPaths)) {
            pPaths = this.mParent.value();
        }
        if (ArrayUtils.isEmpty((Object[])(cPaths = this.mChild.path()))) {
            cPaths = this.mChild.value();
        }
        if (ArrayUtils.isNotEmpty((Object[])pPaths)) {
            ArrayList<String> paths = new ArrayList<String>();
            for (Object pPath : pPaths) {
                for (Object cPath : cPaths) {
                    String copyPath;
                    String path = (String)pPath + (String)cPath;
                    paths.add(path);
                    if (path.endsWith("/")) {
                        if (path.length() <= 1) continue;
                        copyPath = path.substring(0, path.length() - 1);
                        paths.add(copyPath);
                        continue;
                    }
                    copyPath = path + "/";
                    paths.add(copyPath);
                }
            }
            this.mPaths = paths.toArray(new String[0]);
        } else if (ArrayUtils.isNotEmpty((Object[])cPaths)) {
            ArrayList<Object> paths = new ArrayList<Object>();
            for (Object cPath : cPaths) {
                String copyPath;
                paths.add(cPath);
                if (((String)cPath).endsWith("/")) {
                    if (((String)cPath).length() <= 1) continue;
                    copyPath = ((String)cPath).substring(0, ((String)cPath).length() - 1);
                    paths.add(copyPath);
                    continue;
                }
                copyPath = (String)cPath + "/";
                paths.add(copyPath);
            }
            this.mPaths = paths.toArray(new String[0]);
        } else {
            this.mPaths = cPaths;
        }
        this.mPaths = Utils.mergeRepeat(this.mPaths, null, false);
        return this.mPaths;
    }

    @Override
    public String[] method() {
        if (this.mMethods != null) {
            return this.mMethods;
        }
        String[] pMethods = this.mParent.method();
        String[] cMethods = this.mChild.method();
        this.mMethods = Utils.mergeRepeat(pMethods, cMethods, true);
        if (ArrayUtils.isEmpty((Object[])this.mMethods)) {
            this.mMethods = new String[]{RequestMethod.GET.value()};
        }
        return this.mMethods;
    }

    @Override
    public String[] params() {
        if (this.mParams != null) {
            return this.mParams;
        }
        String[] pParams = this.mParent.params();
        String[] cParams = this.mChild.params();
        this.mParams = Utils.mergeRepeat(pParams, cParams, false);
        return this.mParams;
    }

    @Override
    public String[] headers() {
        if (this.mHeaders != null) {
            return this.mHeaders;
        }
        String[] pHeaders = this.mParent.headers();
        String[] cHeaders = this.mChild.headers();
        this.mHeaders = Utils.mergeRepeat(pHeaders, cHeaders, true);
        return this.mHeaders;
    }

    @Override
    public String[] consumes() {
        if (this.mConsumes != null) {
            return this.mConsumes;
        }
        String[] pConsumes = this.mParent.consumes();
        String[] cConsumes = this.mChild.consumes();
        this.mConsumes = Utils.mergeRepeat(pConsumes, cConsumes, true);
        return this.mConsumes;
    }

    @Override
    public String[] produces() {
        if (this.mProduces != null) {
            return this.mProduces;
        }
        String[] pProduces = this.mParent.produces();
        String[] cProduces = this.mChild.produces();
        this.mProduces = Utils.mergeRepeat(pProduces, cProduces, true);
        return this.mProduces;
    }

    @Override
    public boolean isRest() {
        return this.mParent.isRest() || this.mChild.isRest();
    }
}

