/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor.cross;

import com.yanzhenjie.andserver.processor.cross.CrossOriginImpl;
import com.yanzhenjie.andserver.processor.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MergeCrossOrigin {
    private CrossOriginImpl mParent;
    private CrossOriginImpl mChild;
    private String[] mOrigins;
    private String[] mAllowedHeaders;
    private String[] mExposedHeaders;
    private String[] mMethods;

    public MergeCrossOrigin(CrossOriginImpl parent, CrossOriginImpl child) {
        this.mParent = parent;
        this.mChild = child;
    }

    public String[] value() {
        return this.origins();
    }

    public String[] origins() {
        Object[] cOrigins;
        if (this.mOrigins != null) {
            return this.mOrigins;
        }
        Object[] pOrigins = this.mParent.origins();
        if (ArrayUtils.isEmpty((Object[])pOrigins)) {
            pOrigins = this.mParent.value();
        }
        if (ArrayUtils.isEmpty((Object[])(cOrigins = this.mChild.origins()))) {
            cOrigins = this.mChild.value();
        }
        this.mOrigins = Utils.mergeRepeat((String[])pOrigins, (String[])cOrigins, true);
        return this.mOrigins;
    }

    public String[] allowedHeaders() {
        if (this.mAllowedHeaders != null) {
            return this.mAllowedHeaders;
        }
        String[] pHeaders = this.mParent.allowedHeaders();
        String[] cHeaders = this.mChild.allowedHeaders();
        this.mAllowedHeaders = Utils.mergeRepeat(pHeaders, cHeaders, true);
        return this.mAllowedHeaders;
    }

    public String[] exposedHeaders() {
        if (this.mExposedHeaders != null) {
            return this.mExposedHeaders;
        }
        String[] pHeaders = this.mParent.exposedHeaders();
        String[] cHeaders = this.mChild.exposedHeaders();
        this.mExposedHeaders = Utils.mergeRepeat(pHeaders, cHeaders, true);
        return this.mExposedHeaders;
    }

    public String[] methods() {
        if (this.mMethods != null) {
            return this.mMethods;
        }
        String[] pMethods = this.mParent.methods();
        String[] cMethods = this.mChild.methods();
        this.mMethods = Utils.mergeRepeat(pMethods, cMethods, true);
        return this.mMethods;
    }

    public boolean allowCredentials() {
        String cCredentials = this.mChild.allowCredentials();
        if (StringUtils.isNotEmpty((CharSequence)cCredentials)) {
            return Boolean.parseBoolean(cCredentials);
        }
        String pCredentials = this.mChild.allowCredentials();
        if (StringUtils.isNotEmpty((CharSequence)pCredentials)) {
            return Boolean.parseBoolean(pCredentials);
        }
        return true;
    }

    public long maxAge() {
        long cMaxAge = this.mChild.maxAge();
        if (cMaxAge >= 0L) {
            return cMaxAge;
        }
        long pMaxAge = this.mParent.maxAge();
        if (pMaxAge >= 0L) {
            return pMaxAge;
        }
        return 1800L;
    }
}

