/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.yanzhenjie.andserver.annotation.Addition;
import com.yanzhenjie.andserver.annotation.AppInfo;
import com.yanzhenjie.andserver.annotation.Controller;
import com.yanzhenjie.andserver.annotation.CookieValue;
import com.yanzhenjie.andserver.annotation.CrossOrigin;
import com.yanzhenjie.andserver.annotation.DeleteMapping;
import com.yanzhenjie.andserver.annotation.FormPart;
import com.yanzhenjie.andserver.annotation.GetMapping;
import com.yanzhenjie.andserver.annotation.PatchMapping;
import com.yanzhenjie.andserver.annotation.PathVariable;
import com.yanzhenjie.andserver.annotation.PostMapping;
import com.yanzhenjie.andserver.annotation.PutMapping;
import com.yanzhenjie.andserver.annotation.QueryParam;
import com.yanzhenjie.andserver.annotation.RequestBody;
import com.yanzhenjie.andserver.annotation.RequestHeader;
import com.yanzhenjie.andserver.annotation.RequestMapping;
import com.yanzhenjie.andserver.annotation.RequestParam;
import com.yanzhenjie.andserver.annotation.ResponseBody;
import com.yanzhenjie.andserver.annotation.RestController;
import com.yanzhenjie.andserver.processor.BaseProcessor;
import com.yanzhenjie.andserver.processor.cross.CrossOriginImpl;
import com.yanzhenjie.andserver.processor.cross.MergeCrossOrigin;
import com.yanzhenjie.andserver.processor.mapping.Any;
import com.yanzhenjie.andserver.processor.mapping.Delete;
import com.yanzhenjie.andserver.processor.mapping.Get;
import com.yanzhenjie.andserver.processor.mapping.Mapping;
import com.yanzhenjie.andserver.processor.mapping.Merge;
import com.yanzhenjie.andserver.processor.mapping.Null;
import com.yanzhenjie.andserver.processor.mapping.Patch;
import com.yanzhenjie.andserver.processor.mapping.Post;
import com.yanzhenjie.andserver.processor.mapping.Put;
import com.yanzhenjie.andserver.processor.util.Logger;
import com.yanzhenjie.andserver.processor.util.Patterns;
import com.yanzhenjie.andserver.processor.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ControllerProcessor
extends BaseProcessor
implements Patterns {
    private Filer mFiler;
    private Elements mElements;
    private Logger mLog;
    private TypeName mContext;
    private TypeName mTextUtils;
    private ClassName mTypeWrapper;
    private TypeName mMediaType;
    private TypeName mOnRegisterType;
    private TypeName mRegisterType;
    private TypeName mBodyMissing;
    private TypeName mCookieMissing;
    private TypeName mParamMissing;
    private TypeName mHeaderMissing;
    private TypeName mPathMissing;
    private TypeName mParamError;
    private TypeName mAdapter;
    private TypeName mMappingAdapter;
    private TypeName mHandler;
    private TypeName mMappingHandler;
    private TypeName mView;
    private TypeName mViewObject;
    private TypeName mConverter;
    private TypeName mRequest;
    private TypeName mMultipartRequest;
    private TypeName mResponse;
    private TypeName mHttpMethod;
    private TypeName mHttpHeaders;
    private TypeName mSession;
    private TypeName mRequestBody;
    private TypeName mMultipartFile;
    private TypeName mMultipartFileArray;
    private TypeName mMultipartFileList;
    private TypeName mAddition;
    private TypeName mCrossOrigin;
    private TypeName mMapping;
    private TypeName mMimeTypeMapping;
    private TypeName mMethodMapping;
    private TypeName mPairMapping;
    private TypeName mPathMapping;
    private TypeName mMappingList;
    private TypeName mString = TypeName.get(String.class);
    private ArrayTypeName mStringArray = ArrayTypeName.of(String.class);
    private ArrayTypeName mIntArray = ArrayTypeName.of(Integer.TYPE);
    private ArrayTypeName mLongArray = ArrayTypeName.of(Long.TYPE);
    private ArrayTypeName mFloatArray = ArrayTypeName.of(Float.TYPE);
    private ArrayTypeName mDoubleArray = ArrayTypeName.of(Double.TYPE);
    private ArrayTypeName mBooleanArray = ArrayTypeName.of(Boolean.TYPE);
    private TypeName mStringList = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.mString});
    private List<Integer> mHashCodes = new ArrayList<Integer>();
    private Pattern mBlurredPathPattern = Pattern.compile(PATH_BLURRED_INCLUDE);

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mElements = processingEnv.getElementUtils();
        this.mLog = new Logger(processingEnv.getMessager());
        this.mContext = TypeName.get((TypeMirror)this.mElements.getTypeElement("android.content.Context").asType());
        this.mTextUtils = TypeName.get((TypeMirror)this.mElements.getTypeElement("android.text.TextUtils").asType());
        this.mTypeWrapper = ClassName.get((TypeElement)this.mElements.getTypeElement("com.yanzhenjie.andserver.util.TypeWrapper"));
        this.mMediaType = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.util.MediaType").asType());
        this.mOnRegisterType = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.register.OnRegister").asType());
        this.mRegisterType = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.register.Register").asType());
        this.mBodyMissing = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.BodyMissingException").asType());
        this.mCookieMissing = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.CookieMissingException").asType());
        this.mParamMissing = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.ParamMissingException").asType());
        this.mHeaderMissing = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.HeaderMissingException").asType());
        this.mPathMissing = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.PathMissingException").asType());
        this.mParamError = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.error.ParamValidateException").asType());
        this.mConverter = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.MessageConverter").asType());
        this.mAdapter = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.handler.HandlerAdapter").asType());
        this.mMappingAdapter = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.handler.MappingAdapter").asType());
        this.mHandler = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.handler.RequestHandler").asType());
        this.mMappingHandler = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.handler.MappingHandler").asType());
        this.mView = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.view.View").asType());
        this.mViewObject = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.view.ObjectView").asType());
        this.mRequest = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.HttpRequest").asType());
        this.mMultipartRequest = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.multipart.MultipartRequest").asType());
        this.mResponse = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.HttpResponse").asType());
        this.mHttpMethod = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.HttpMethod").asType());
        this.mHttpHeaders = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.HttpHeaders").asType());
        this.mSession = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.session.Session").asType());
        this.mRequestBody = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.RequestBody").asType());
        this.mMultipartFile = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.http.multipart.MultipartFile").asType());
        this.mMultipartFileArray = ArrayTypeName.of((TypeName)this.mMultipartFile);
        this.mMultipartFileList = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.mMultipartFile});
        this.mAddition = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Addition").asType());
        this.mCrossOrigin = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.cross.CrossOrigin").asType());
        this.mMapping = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Mapping").asType());
        this.mMimeTypeMapping = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Mime").asType());
        this.mMethodMapping = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Method").asType());
        this.mPairMapping = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Pair").asType());
        this.mPathMapping = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.mapping.Path").asType());
        this.mMappingList = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.mMapping, this.mHandler});
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        if (CollectionUtils.isEmpty(set)) {
            return false;
        }
        Set<? extends Element> appSet = roundEnv.getElementsAnnotatedWith(AppInfo.class);
        String registerPackageName = this.getRegisterPackageName(appSet);
        HashMap<TypeElement, List<ExecutableElement>> controllers = new HashMap<TypeElement, List<ExecutableElement>>();
        this.findMapping(roundEnv.getElementsAnnotatedWith(RequestMapping.class), controllers);
        this.findMapping(roundEnv.getElementsAnnotatedWith(GetMapping.class), controllers);
        this.findMapping(roundEnv.getElementsAnnotatedWith(PostMapping.class), controllers);
        this.findMapping(roundEnv.getElementsAnnotatedWith(PutMapping.class), controllers);
        this.findMapping(roundEnv.getElementsAnnotatedWith(PatchMapping.class), controllers);
        this.findMapping(roundEnv.getElementsAnnotatedWith(DeleteMapping.class), controllers);
        if (!controllers.isEmpty()) {
            this.createHandlerAdapter(registerPackageName, controllers);
        }
        return true;
    }

    private void findMapping(Set<? extends Element> set, Map<TypeElement, List<ExecutableElement>> controllerMap) {
        for (Element element : set) {
            List<ExecutableElement> elementList;
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement execute = (ExecutableElement)element;
            Element enclosing = element.getEnclosingElement();
            if (!(enclosing instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)enclosing;
            RestController restController = type.getAnnotation(RestController.class);
            Controller controller = type.getAnnotation(Controller.class);
            if (restController == null && controller == null) {
                this.mLog.w(String.format("Controller/RestController annotations may be missing on %s.", type.getQualifiedName()));
                continue;
            }
            String host = type.getQualifiedName() + "#" + execute.getSimpleName() + "()";
            Set<Modifier> modifiers = execute.getModifiers();
            Validate.isTrue((!modifiers.contains((Object)Modifier.PRIVATE) ? 1 : 0) != 0, (String)"The modifier private is redundant on %s.", (Object[])new Object[]{host});
            if (modifiers.contains((Object)Modifier.STATIC)) {
                this.mLog.w(String.format("The modifier static is redundant on %s.", host));
            }
            if (CollectionUtils.isEmpty(elementList = controllerMap.get(type))) {
                elementList = new ArrayList<ExecutableElement>();
                controllerMap.put(type, elementList);
            }
            elementList.add(execute);
        }
    }

    private void createHandlerAdapter(String registerPackageName, Map<TypeElement, List<ExecutableElement>> controllers) {
        HashMap<String, List<String>> adapterMap = new HashMap<String, List<String>>();
        for (Map.Entry<TypeElement, List<ExecutableElement>> entry : controllers.entrySet()) {
            TypeElement type = entry.getKey();
            List<ExecutableElement> executes = entry.getValue();
            this.mLog.i(String.format("------ Processing %s ------", type.getSimpleName()));
            String typeName = type.getQualifiedName().toString();
            Mapping typeMapping = this.getTypeMapping(type);
            this.validateMapping(typeMapping, typeName);
            CrossOrigin typeCrossOrigin = type.getAnnotation(CrossOrigin.class);
            TypeName controllerType = TypeName.get((TypeMirror)type.asType());
            FieldSpec hostField = FieldSpec.builder((TypeName)controllerType, (String)"mHost", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            FieldSpec mappingField = FieldSpec.builder((TypeName)this.mMappingList, (String)"mMappingMap", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            CodeBlock.Builder rootCode = CodeBlock.builder().addStatement("this.mHost = new $T()", new Object[]{type}).addStatement("this.mMappingMap = new $T<>()", new Object[]{LinkedHashMap.class});
            for (ExecutableElement execute : executes) {
                Mapping mapping = this.getExecuteMapping(execute);
                this.validateExecuteMapping(mapping, typeName + "#" + execute.getSimpleName().toString() + "()");
                mapping = new Merge(typeMapping, mapping);
                rootCode.beginControlFlow("\n", new Object[0]).addStatement("$T mapping = new $T()", new Object[]{this.mMapping, this.mMapping});
                this.addMapping(rootCode, mapping);
                Addition addition = execute.getAnnotation(Addition.class);
                rootCode.add("\n", new Object[0]).addStatement("$T addition = new $T()", new Object[]{this.mAddition, this.mAddition});
                this.addAddition(rootCode, addition);
                CrossOrigin executeCrossOrigin = execute.getAnnotation(CrossOrigin.class);
                if (typeCrossOrigin == null && executeCrossOrigin == null) {
                    rootCode.add("\n", new Object[0]).addStatement("$T crossOrigin = null", new Object[]{this.mCrossOrigin});
                } else {
                    rootCode.add("\n", new Object[0]).addStatement("$T crossOrigin = new $T()", new Object[]{this.mCrossOrigin, this.mCrossOrigin});
                    MergeCrossOrigin crossOrigin = new MergeCrossOrigin(new CrossOriginImpl(typeCrossOrigin), new CrossOriginImpl(executeCrossOrigin));
                    this.addCrossOrigin(rootCode, crossOrigin);
                }
                String handlerName = this.createHandler(type, execute, mapping.path(), mapping.isRest());
                rootCode.addStatement("$L handler = new $L(mHost, mapping, addition, crossOrigin)", new Object[]{handlerName, handlerName}).addStatement("mMappingMap.put(mapping, handler)", new Object[0]).endControlFlow();
            }
            MethodSpec rootMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(rootCode.build()).build();
            MethodSpec mappingMethod = MethodSpec.methodBuilder((String)"getMappingMap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(this.mMappingList).addStatement("return mMappingMap", new Object[0]).build();
            MethodSpec hostMethod = MethodSpec.methodBuilder((String)"getHost").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(controllerType).addStatement("return mHost", new Object[0]).build();
            String adapterPackageName = this.getPackageName(type).getQualifiedName().toString();
            String className = String.format("%sAdapter", type.getSimpleName());
            TypeSpec adapterClass = TypeSpec.classBuilder((String)className).addJavadoc("This file was generated by AndServer automatically and you should NOT edit it.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(this.mMappingAdapter).addField(hostField).addField(mappingField).addMethod(rootMethod).addMethod(mappingMethod).addMethod(hostMethod).build();
            JavaFile javaFile = JavaFile.builder((String)adapterPackageName, (TypeSpec)adapterClass).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String group = this.getGroup(type);
            ArrayList<String> adapterList = (ArrayList<String>)adapterMap.get(group);
            if (CollectionUtils.isEmpty((Collection)adapterList)) {
                adapterList = new ArrayList<String>();
                adapterMap.put(group, adapterList);
            }
            adapterList.add(adapterPackageName + "." + className);
        }
        if (!adapterMap.isEmpty()) {
            this.createRegister(registerPackageName, adapterMap);
        }
    }

    private Mapping getTypeMapping(TypeElement type) {
        DeleteMapping deleteMapping;
        PatchMapping patchMapping;
        PutMapping putMapping;
        PostMapping postMapping;
        GetMapping getMapping;
        Mapping mapping = null;
        boolean isRest = type.getAnnotation(ResponseBody.class) != null || type.getAnnotation(RestController.class) != null;
        RequestMapping requestMapping = type.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            mapping = new Any(requestMapping, isRest);
        }
        if (mapping == null && (getMapping = type.getAnnotation(GetMapping.class)) != null) {
            mapping = new Get(getMapping, isRest);
        }
        if (mapping == null && (postMapping = type.getAnnotation(PostMapping.class)) != null) {
            mapping = new Post(postMapping, isRest);
        }
        if (mapping == null && (putMapping = type.getAnnotation(PutMapping.class)) != null) {
            mapping = new Put(putMapping, isRest);
        }
        if (mapping == null && (patchMapping = type.getAnnotation(PatchMapping.class)) != null) {
            mapping = new Patch(patchMapping, isRest);
        }
        if (mapping == null && (deleteMapping = type.getAnnotation(DeleteMapping.class)) != null) {
            mapping = new Delete(deleteMapping, isRest);
        }
        if (mapping == null) {
            mapping = new Null(isRest);
        }
        return mapping;
    }

    private void validateMapping(Mapping mapping, String host) {
        Object[] produces;
        Object[] consumes;
        Object[] headers;
        Object[] params;
        Object[] paths = mapping.path();
        if (ArrayUtils.isEmpty((Object[])paths)) {
            paths = mapping.value();
        }
        if (ArrayUtils.isNotEmpty((Object[])paths)) {
            for (Object path : paths) {
                boolean valid = ((String)path).matches(PATH_STRICT) || ((String)path).matches(PATH_BLURRED_MAYBE);
                Validate.isTrue((boolean)valid, (String)"The format of path [%s] is wrong on %s.", (Object[])new Object[]{path, host});
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(params = mapping.params()))) {
            for (Object param : params) {
                boolean valid = ((String)param).matches(PAIR_KEY);
                valid = valid || ((String)param).matches(PAIR_KEY_VALUE);
                valid = valid || ((String)param).matches(PAIR_NO_KEY);
                valid = valid || ((String)param).matches(PAIR_NO_VALUE);
                Validate.isTrue((boolean)valid, (String)"The format of param [%s] is wrong on %s.", (Object[])new Object[]{param, host});
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(headers = mapping.headers()))) {
            for (Object head : headers) {
                boolean valid = ((String)head).matches(PAIR_KEY);
                valid = valid || ((String)head).matches(PAIR_KEY_VALUE);
                valid = valid || ((String)head).matches(PAIR_NO_KEY);
                valid = valid || ((String)head).matches(PAIR_NO_VALUE);
                Validate.isTrue((boolean)valid, (String)"The format of header [%s] is wrong on %s.", (Object[])new Object[]{head, host});
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(consumes = mapping.consumes()))) {
            for (Object consume : consumes) {
                try {
                    Utils.parseMimeType((String)consume);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(String.format("The format of consume [%s] is wrong on %s.", consume, host));
                }
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(produces = mapping.produces()))) {
            for (Object produce : produces) {
                try {
                    Utils.parseMimeType((String)produce);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(String.format("The format of produce [%s] is wrong on %s.", produce, host));
                }
            }
        }
    }

    private Mapping getExecuteMapping(ExecutableElement execute) {
        DeleteMapping deleteMapping;
        PatchMapping patchMapping;
        PutMapping putMapping;
        PostMapping postMapping;
        GetMapping getMapping;
        boolean isRest;
        Mapping mapping = null;
        RequestMapping requestMapping = execute.getAnnotation(RequestMapping.class);
        boolean bl = isRest = execute.getAnnotation(ResponseBody.class) != null;
        if (requestMapping != null) {
            mapping = new Any(requestMapping, isRest);
        }
        if (mapping == null && (getMapping = execute.getAnnotation(GetMapping.class)) != null) {
            mapping = new Get(getMapping, isRest);
        }
        if (mapping == null && (postMapping = execute.getAnnotation(PostMapping.class)) != null) {
            mapping = new Post(postMapping, isRest);
        }
        if (mapping == null && (putMapping = execute.getAnnotation(PutMapping.class)) != null) {
            mapping = new Put(putMapping, isRest);
        }
        if (mapping == null && (patchMapping = execute.getAnnotation(PatchMapping.class)) != null) {
            mapping = new Patch(patchMapping, isRest);
        }
        if (mapping == null && (deleteMapping = execute.getAnnotation(DeleteMapping.class)) != null) {
            mapping = new Delete(deleteMapping, isRest);
        }
        return mapping;
    }

    private void validateExecuteMapping(Mapping mapping, String host) {
        Object[] paths = mapping.path();
        if (ArrayUtils.isEmpty((Object[])paths)) {
            paths = mapping.value();
        }
        Validate.notEmpty((Object[])paths, (String)String.format("The path value of method cannot be empty on %s.", host), (Object[])new Object[0]);
        this.validateMapping(mapping, host);
    }

    private void addMapping(CodeBlock.Builder builder, Mapping mapping) {
        Object[] produceArray;
        Object[] consumeArray;
        Object[] headerArray;
        String[] pathArray = mapping.path();
        builder.add("\n", new Object[0]).addStatement("$T path = new $T()", new Object[]{this.mPathMapping, this.mPathMapping});
        for (String path : pathArray) {
            builder.addStatement("path.addRule($S)", new Object[]{path});
        }
        builder.addStatement("mapping.setPath(path)", new Object[0]);
        String[] methodArray = mapping.method();
        builder.add("\n", new Object[0]).addStatement("$T method = new $T()", new Object[]{this.mMethodMapping, this.mMethodMapping});
        for (String method : methodArray) {
            builder.addStatement("method.addRule($S)", new Object[]{method});
        }
        builder.addStatement("mapping.setMethod(method)", new Object[0]);
        Object[] paramArray = mapping.params();
        if (ArrayUtils.isNotEmpty((Object[])paramArray)) {
            builder.add("\n", new Object[0]).addStatement("$T param = new $T()", new Object[]{this.mPairMapping, this.mPairMapping});
            for (Object param : paramArray) {
                builder.addStatement("param.addRule($S)", new Object[]{param});
            }
            builder.addStatement("mapping.setParam(param)", new Object[0]);
        }
        if (ArrayUtils.isNotEmpty((Object[])(headerArray = mapping.headers()))) {
            builder.add("\n", new Object[0]).addStatement("$T header = new $T()", new Object[]{this.mPairMapping, this.mPairMapping});
            for (Object header : headerArray) {
                builder.addStatement("header.addRule($S)", new Object[]{header});
            }
            builder.addStatement("mapping.setHeader(header)", new Object[0]);
        }
        if (ArrayUtils.isNotEmpty((Object[])(consumeArray = mapping.consumes()))) {
            builder.add("\n", new Object[0]).addStatement("$T consume = new $T()", new Object[]{this.mMimeTypeMapping, this.mMimeTypeMapping});
            for (Object consume : consumeArray) {
                builder.addStatement("consume.addRule($S)", new Object[]{consume});
            }
            builder.addStatement("mapping.setConsume(consume)", new Object[0]);
        }
        if (ArrayUtils.isNotEmpty((Object[])(produceArray = mapping.produces()))) {
            builder.add("\n", new Object[0]).addStatement("$T produce = new $T()", new Object[]{this.mMimeTypeMapping, this.mMimeTypeMapping});
            for (Object produce : produceArray) {
                builder.addStatement("produce.addRule($S)", new Object[]{produce});
            }
            builder.addStatement("mapping.setProduce(produce)", new Object[0]);
        }
    }

    private void addAddition(CodeBlock.Builder builder, Addition addition) {
        if (addition == null) {
            return;
        }
        Object[] stringType = addition.stringType();
        if (ArrayUtils.isEmpty((Object[])stringType)) {
            stringType = addition.value();
        }
        StringBuilder stringArray = new StringBuilder();
        for (Object type : stringType) {
            if (stringArray.length() > 0) {
                stringArray.append(", ");
            }
            stringArray.append("\"").append((String)type).append("\"");
        }
        builder.add("\n", new Object[0]).addStatement("String[] stringType = new String[]{$L}", new Object[]{stringArray}).addStatement("addition.setStringType(stringType)", new Object[0]);
        boolean[] booleanType = addition.booleanType();
        StringBuilder booleanArray = new StringBuilder();
        for (boolean bl : booleanType) {
            if (booleanArray.length() > 0) {
                booleanArray.append(", ");
            }
            booleanArray.append(bl);
        }
        builder.add("\n", new Object[0]).addStatement("boolean[] booleanType = new boolean[]{$L}", new Object[]{booleanArray}).addStatement("addition.setBooleanType(booleanType)", new Object[0]);
        int[] intType = addition.intTypeType();
        StringBuilder intArray = new StringBuilder();
        for (int type : intType) {
            if (intArray.length() > 0) {
                intArray.append(", ");
            }
            intArray.append(type);
        }
        builder.add("\n", new Object[0]).addStatement("int[] intType = new int[]{$L}", new Object[]{intArray}).addStatement("addition.setIntType(intType)", new Object[0]);
        long[] longType = addition.longType();
        StringBuilder stringBuilder = new StringBuilder();
        for (long type : longType) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(type).append("L");
        }
        builder.add("\n", new Object[0]).addStatement("long[] longType = new long[]{$L}", new Object[]{stringBuilder}).addStatement("addition.setLongType(longType)", new Object[0]);
        short[] shortType = addition.shortType();
        StringBuilder shortArray = new StringBuilder();
        for (short s : shortType) {
            if (shortArray.length() > 0) {
                shortArray.append(", ");
            }
            shortArray.append(s);
        }
        builder.add("\n", new Object[0]).addStatement("short[] shortType = new short[]{$L}", new Object[]{shortArray}).addStatement("addition.setShortType(shortType)", new Object[0]);
        float[] floatType = addition.floatType();
        StringBuilder floatArray = new StringBuilder();
        for (float type : floatType) {
            if (floatArray.length() > 0) {
                floatArray.append(", ");
            }
            floatArray.append(type).append("F");
        }
        builder.add("\n", new Object[0]).addStatement("float[] floatType = new float[]{$L}", new Object[]{floatArray}).addStatement("addition.setFloatType(floatType)", new Object[0]);
        double[] doubleType = addition.doubleType();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (double type : doubleType) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(type).append("D");
        }
        builder.add("\n", new Object[0]).addStatement("double[] doubleType = new double[]{$L}", new Object[]{stringBuilder2}).addStatement("addition.setDoubleType(doubleType)", new Object[0]);
        byte[] byteType = addition.byteType();
        StringBuilder byteArray = new StringBuilder();
        for (byte type : byteType) {
            if (byteArray.length() > 0) {
                byteArray.append(", ");
            }
            byteArray.append(type);
        }
        builder.add("\n", new Object[0]).addStatement("byte[] byteType = new byte[]{$L}", new Object[]{byteArray}).addStatement("addition.setByteType(byteType)", new Object[0]);
        char[] charType = addition.charType();
        StringBuilder charArray = new StringBuilder();
        for (char type : charType) {
            if (charArray.length() > 0) {
                charArray.append(", ");
            }
            charArray.append("'").append(type).append("'");
        }
        builder.add("\n", new Object[0]).addStatement("char[] charType = new char[]{$L}", new Object[]{charArray}).addStatement("addition.setCharType(charType)", new Object[0]);
    }

    private void addCrossOrigin(CodeBlock.Builder builder, MergeCrossOrigin crossOrigin) {
        String[] origins = crossOrigin.origins();
        StringBuilder originsArray = new StringBuilder();
        for (String origin : origins) {
            if (originsArray.length() > 0) {
                originsArray.append(", ");
            }
            originsArray.append("\"").append(origin).append("\"");
        }
        builder.add("\n", new Object[0]).addStatement("String[] origins = new String[]{$L}", new Object[]{originsArray}).addStatement("crossOrigin.setOrigins(origins)", new Object[0]);
        String[] allowedHeaders = crossOrigin.allowedHeaders();
        StringBuilder allowedHeadersArray = new StringBuilder();
        for (String header : allowedHeaders) {
            if (allowedHeadersArray.length() > 0) {
                allowedHeadersArray.append(", ");
            }
            allowedHeadersArray.append("\"").append(header).append("\"");
        }
        builder.add("\n", new Object[0]).addStatement("String[] allowedHeaders = new String[]{$L}", new Object[]{allowedHeadersArray}).addStatement("crossOrigin.setAllowedHeaders(allowedHeaders)", new Object[0]);
        String[] exposedHeaders = crossOrigin.exposedHeaders();
        StringBuilder exposedHeadersArray = new StringBuilder();
        for (String header : exposedHeaders) {
            if (exposedHeadersArray.length() > 0) {
                exposedHeadersArray.append(", ");
            }
            exposedHeadersArray.append("\"").append(header).append("\"");
        }
        builder.add("\n", new Object[0]).addStatement("String[] exposedHeaders = new String[]{$L}", new Object[]{exposedHeadersArray}).addStatement("crossOrigin.setExposedHeaders(exposedHeaders)", new Object[0]);
        String[] methods = crossOrigin.methods();
        StringBuilder methodsArray = new StringBuilder();
        for (String method : methods) {
            if (methodsArray.length() > 0) {
                methodsArray.append(", ");
            }
            methodsArray.append("HttpMethod.").append(method);
        }
        builder.add("\n", new Object[0]).addStatement("$T[] methods = new $T[]{$L}", new Object[]{this.mHttpMethod, this.mHttpMethod, methodsArray}).addStatement("crossOrigin.setMethods(methods)", new Object[0]);
        boolean allowCredentials = crossOrigin.allowCredentials();
        builder.add("\n", new Object[0]).addStatement("crossOrigin.setAllowCredentials($L)", new Object[]{allowCredentials});
        long maxAge = crossOrigin.maxAge();
        builder.addStatement("crossOrigin.setMaxAge($L)", new Object[]{maxAge});
    }

    private String createHandler(TypeElement type, ExecutableElement execute, String[] paths, boolean isRest) {
        FieldSpec hostField = FieldSpec.builder(Object.class, (String)"mHost", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        MethodSpec rootMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "host", new Modifier[0]).addParameter(this.mMapping, "mapping", new Modifier[0]).addParameter(this.mAddition, "addition", new Modifier[0]).addParameter(this.mCrossOrigin, "crossOrigin", new Modifier[0]).addStatement("super(host, mapping, addition, crossOrigin)", new Object[0]).addStatement("this.mHost = host", new Object[0]).build();
        CodeBlock.Builder handleCode = CodeBlock.builder().addStatement("$T context = ($T)request.getAttribute($T.ANDROID_CONTEXT)", new Object[]{this.mContext, this.mContext, this.mRequest}).addStatement("String httpPath = request.getPath()", new Object[0]).addStatement("$T httpMethod = request.getMethod()", new Object[]{this.mHttpMethod}).add("\n", new Object[0]).addStatement("Object converterObj = request.getAttribute($T.HTTP_MESSAGE_CONVERTER)", new Object[]{this.mRequest}).addStatement("$T converter = null", new Object[]{this.mConverter}).beginControlFlow("if (converterObj != null && converterObj instanceof $T)", new Object[]{this.mConverter}).addStatement("converter = ($T)converterObj", new Object[]{this.mConverter}).endControlFlow().add("\n", new Object[0]).addStatement("$T multiRequest = null", new Object[]{this.mMultipartRequest}).beginControlFlow("if (request instanceof $T)", new Object[]{this.mMultipartRequest}).addStatement("multiRequest = ($T) request", new Object[]{this.mMultipartRequest}).endControlFlow().add("\n", new Object[0]).addStatement("$T requestBody = null", new Object[]{this.mRequestBody}).beginControlFlow("if (httpMethod.allowBody())", new Object[0]).addStatement("requestBody = request.getBody()", new Object[0]).endControlFlow().add("\n", new Object[0]).addStatement("$T<String, String> pathMap = getPathVariable(httpPath)", new Object[]{Map.class}).add("\n", new Object[0]).add("/** ---------- Building Parameters ---------- **/ ", new Object[0]).add("\n", new Object[0]);
        String host = type.getQualifiedName().toString() + "#" + execute.getSimpleName().toString() + "()";
        StringBuilder paramBuild = new StringBuilder();
        List<? extends VariableElement> parameters = execute.getParameters();
        if (!parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement parameter = parameters.get(i);
                TypeName typeName = TypeName.get((TypeMirror)parameter.asType());
                if (this.mContext.equals((Object)typeName)) {
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append("context");
                    continue;
                }
                if (this.mRequest.equals((Object)typeName)) {
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append("request");
                    continue;
                }
                if (this.mResponse.equals((Object)typeName)) {
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append("response");
                    continue;
                }
                if (this.mSession.equals((Object)typeName)) {
                    handleCode.add("\n", new Object[0]).addStatement("$T session$L = request.getValidSession()", new Object[]{this.mSession, i});
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format("session%s", i));
                    continue;
                }
                if (this.mRequestBody.equals((Object)typeName)) {
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append("requestBody");
                    continue;
                }
                RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
                if (requestHeader != null) {
                    Validate.isTrue((boolean)this.isBasicType(typeName), (String)"The RequestHeader annotation only supports [String, int, long, float, double, boolean] on %s.", (Object[])new Object[]{host});
                    String name = requestHeader.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = requestHeader.value();
                    }
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"The name of param is null on %s.", (Object[])new Object[]{host});
                    String defaultValue = requestHeader.defaultValue();
                    handleCode.add("\n", new Object[0]).addStatement("String header$LStr = request.getHeader($S)", new Object[]{i, name});
                    if (requestHeader.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                        handleCode.beginControlFlow("if ($T.isEmpty(header$LStr))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mHeaderMissing, name}).endControlFlow();
                    } else {
                        handleCode.beginControlFlow("if ($T.isEmpty(header$LStr))", new Object[]{this.mTextUtils, i}).addStatement("header$LStr = $S", new Object[]{i, defaultValue}).endControlFlow();
                    }
                    this.createBasicParameter(handleCode, typeName, "header", i);
                    this.assignmentBasicParameter(handleCode, typeName, "header", i);
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "header%d", i));
                    continue;
                }
                CookieValue cookieValue = parameter.getAnnotation(CookieValue.class);
                if (cookieValue != null) {
                    Validate.isTrue((boolean)this.mString.equals((Object)typeName), (String)"CookieValue can only be used with [String] on %s.", (Object[])new Object[]{host});
                    String name = cookieValue.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = cookieValue.value();
                    }
                    Validate.notEmpty((CharSequence)name, (String)"The name of cookie is null on %s.", (Object[])new Object[]{host});
                    String defaultValue = cookieValue.defaultValue();
                    handleCode.add("\n", new Object[0]).addStatement("String cookie$L = request.getCookieValue($S)", new Object[]{i, name});
                    if (cookieValue.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                        handleCode.beginControlFlow("if ($T.isEmpty(cookie$L))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mCookieMissing, name}).endControlFlow();
                    } else {
                        handleCode.beginControlFlow("if ($T.isEmpty(cookie$L))", new Object[]{this.mTextUtils, i}).addStatement("cookie$L = $S;", new Object[]{i, defaultValue}).endControlFlow();
                    }
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "cookie%d", i));
                    continue;
                }
                PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
                if (pathVariable != null) {
                    Validate.isTrue((boolean)this.isBasicType(typeName), (String)"The PathVariable annotation only supports [String, int, long, float, double, boolean] on %s.", (Object[])new Object[]{host});
                    String name = pathVariable.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = pathVariable.value();
                    }
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"The name of path is null on %s.", (Object[])new Object[]{host});
                    String defaultValue = pathVariable.defaultValue();
                    boolean isBlurred = false;
                    for (String path : paths) {
                        if (!path.matches(PATH_BLURRED_MAYBE) || !this.mBlurredPathPattern.matcher(path).find()) continue;
                        isBlurred = true;
                    }
                    Validate.isTrue((boolean)isBlurred, (String)"The PathVariable annotation must have a blurred path, for example [/project/{name}]. The error occurred on %s.", (Object[])new Object[]{host});
                    handleCode.add("\n", new Object[0]).addStatement("String path$LStr = pathMap.get($S)", new Object[]{i, name});
                    if (pathVariable.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                        handleCode.beginControlFlow("if ($T.isEmpty(path$LStr))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mPathMissing, name}).endControlFlow();
                    } else {
                        handleCode.beginControlFlow("if ($T.isEmpty(path$LStr))", new Object[]{this.mTextUtils, i}).addStatement("path$LStr = $S;", new Object[]{i, defaultValue}).endControlFlow();
                    }
                    this.createBasicParameter(handleCode, typeName, "path", i);
                    this.assignmentBasicParameter(handleCode, typeName, "path", i);
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "path%d", i));
                    continue;
                }
                QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
                if (queryParam != null) {
                    boolean isBasicType = this.isBasicType(typeName);
                    boolean isBasicArrayType = this.isBasicArrayType(typeName);
                    Validate.isTrue((isBasicType || isBasicArrayType ? 1 : 0) != 0, (String)"The QueryParam annotation only supports [String, int, long, float, double, boolean] on %s.", (Object[])new Object[]{host});
                    String name = queryParam.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = queryParam.value();
                    }
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"The name of param is null on %s.", (Object[])new Object[]{host});
                    String defaultValue = queryParam.defaultValue();
                    if (isBasicType) {
                        handleCode.add("\n", new Object[0]).addStatement("String param$LStr = request.getQuery($S)", new Object[]{i, name});
                        if (queryParam.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        } else {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("param$LStr = $S", new Object[]{i, defaultValue}).endControlFlow();
                        }
                        this.createBasicParameter(handleCode, typeName, "param", i);
                        this.assignmentBasicParameter(handleCode, typeName, "param", i);
                    } else {
                        handleCode.add("\n", new Object[0]).addStatement("$T param$LList = request.getQueries($S)", new Object[]{this.mStringList, i, name});
                        if (queryParam.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                            handleCode.beginControlFlow("if (param$LList == null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        } else {
                            handleCode.beginControlFlow("if (param$LList = null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("param$LList = new $T<>()", new Object[]{i, TypeName.get(ArrayList.class)}).addStatement("param$LList.add($S)", new Object[]{i, defaultValue}).endControlFlow();
                        }
                        this.createBasicArrayParameter(handleCode, typeName, i);
                        this.assignmentBasicArrayParameter(handleCode, typeName, i);
                    }
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "param%d", i));
                    continue;
                }
                RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
                if (requestParam != null) {
                    boolean isFile = this.mMultipartFile.equals((Object)typeName) || this.mMultipartFileArray.equals((Object)typeName);
                    boolean isBasicType = this.isBasicType(typeName);
                    boolean isBasicArrayType = this.isBasicArrayType(typeName);
                    String name = requestParam.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = requestParam.value();
                    }
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"The name of param is null on %s.", (Object[])new Object[]{host});
                    String defaultValue = requestParam.defaultValue();
                    handleCode.add("\n", new Object[0]);
                    if (isFile) {
                        if (this.mMultipartFile.equals((Object)typeName)) {
                            handleCode.addStatement("$T param$L = null", new Object[]{this.mMultipartFile, i}).beginControlFlow("if (multiRequest != null)", new Object[0]).addStatement("param$L = multiRequest.getFile($S)", new Object[]{i, name}).endControlFlow();
                            if (requestParam.required()) {
                                handleCode.beginControlFlow("if (param$L == null)", new Object[]{i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                            }
                        } else {
                            handleCode.addStatement("$T param$LList = null", new Object[]{this.mMultipartFileList, i}).beginControlFlow("if (multiRequest != null)", new Object[0]).addStatement("param$LList = multiRequest.getFiles($S)", new Object[]{i, name}).endControlFlow();
                            if (requestParam.required()) {
                                handleCode.beginControlFlow("if (param$LList == null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                            }
                            handleCode.addStatement("int param$LListSize = param$LList.size()", new Object[]{i, i}).addStatement("$T[] param$L = new $T[param$LListSize]", new Object[]{this.mMultipartFile, i, this.mMultipartFile, i}).beginControlFlow("if(param$LListSize > 0)", new Object[]{i}).addStatement("param$LList.toArray(param$L)", new Object[]{i, i}).endControlFlow();
                        }
                    } else if (isBasicType) {
                        handleCode.addStatement("String param$LStr = request.getParameter($S)", new Object[]{i, name});
                        if (requestParam.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        } else {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("param$LStr = $S", new Object[]{i, defaultValue}).endControlFlow();
                        }
                        this.createBasicParameter(handleCode, typeName, "param", i);
                        this.assignmentBasicParameter(handleCode, typeName, "param", i);
                    } else if (isBasicArrayType) {
                        handleCode.addStatement("$T param$LList = request.getParameters($S)", new Object[]{this.mStringList, i, name});
                        if (requestParam.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                            handleCode.beginControlFlow("if (param$LList == null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        } else {
                            handleCode.beginControlFlow("if (param$LList == null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("param$LList = new $T<>()", new Object[]{i, TypeName.get(ArrayList.class)}).addStatement("param$LList.add($S)", new Object[]{i, defaultValue}).endControlFlow();
                        }
                        this.createBasicArrayParameter(handleCode, typeName, i);
                        this.assignmentBasicArrayParameter(handleCode, typeName, i);
                    } else {
                        handleCode.addStatement("String param$LStr = request.getParameter($S)", new Object[]{i, name});
                        if (requestParam.required() && StringUtils.isEmpty((CharSequence)defaultValue)) {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        } else {
                            handleCode.beginControlFlow("if ($T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("param$LStr = $S", new Object[]{i, requestParam.defaultValue()}).endControlFlow();
                        }
                        ParameterizedTypeName wrapperType = ParameterizedTypeName.get((ClassName)this.mTypeWrapper, (TypeName[])new TypeName[]{typeName});
                        handleCode.addStatement("$T param$L = null", new Object[]{typeName, i}).beginControlFlow("if (converter != null && !$T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("byte[] data = param$LStr.getBytes()", new Object[]{i}).addStatement("$T stream = new $T(data)", new Object[]{InputStream.class, ByteArrayInputStream.class}).addStatement("$T mimeType = $T.TEXT_PLAIN", new Object[]{this.mMediaType, this.mMediaType}).addStatement("$T type = new $T(){}.getType()", new Object[]{Type.class, wrapperType}).addStatement("param$L = converter.convert(stream, mimeType, type)", new Object[]{i}).endControlFlow();
                    }
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "param%d", i));
                    continue;
                }
                FormPart formPart = parameter.getAnnotation(FormPart.class);
                if (formPart != null) {
                    String name = formPart.name();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = formPart.value();
                    }
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"The name of param is null on %s.", (Object[])new Object[]{host});
                    handleCode.add("\n", new Object[0]);
                    if (this.mMultipartFile.equals((Object)typeName)) {
                        handleCode.addStatement("$T param$L = null", new Object[]{this.mMultipartFile, i}).beginControlFlow("if (multiRequest != null)", new Object[0]).addStatement("param$L = multiRequest.getFile($S)", new Object[]{i, name}).endControlFlow();
                        if (formPart.required()) {
                            handleCode.beginControlFlow("if (param$L == null)", new Object[]{i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        }
                    } else if (this.mMultipartFileArray.equals((Object)typeName)) {
                        handleCode.addStatement("$T param$LList = null", new Object[]{this.mMultipartFileList, i}).beginControlFlow("if (multiRequest != null)", new Object[0]).addStatement("param$LList = multiRequest.getFiles($S)", new Object[]{i, name}).endControlFlow();
                        if (formPart.required()) {
                            handleCode.beginControlFlow("if (param$LList == null || param$LList.isEmpty())", new Object[]{i, i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        }
                        handleCode.addStatement("int param$LListSize = param$LList.size()", new Object[]{i, i}).addStatement("$T[] param$L = new $T[param$LListSize]", new Object[]{this.mMultipartFile, i, this.mMultipartFile, i}).beginControlFlow("if(param$LListSize > 0)", new Object[]{i}).addStatement("param$LList.toArray(param$L)", new Object[]{i, i}).endControlFlow();
                    } else {
                        ParameterizedTypeName wrapperType = ParameterizedTypeName.get((ClassName)this.mTypeWrapper, (TypeName[])new TypeName[]{typeName});
                        handleCode.addStatement("$T param$L = null", new Object[]{typeName, i}).beginControlFlow("if (converter != null && multiRequest != null)", new Object[0]).addStatement("$T param$LType = new $T(){}.getType()", new Object[]{Type.class, i, wrapperType}).addStatement("$T param$LFile = multiRequest.getFile($S)", new Object[]{this.mMultipartFile, i, name}).beginControlFlow("if (param$LFile != null)", new Object[]{i}).addStatement("$T stream = param$LFile.getStream()", new Object[]{InputStream.class, i}).addStatement("$T mimeType = param$LFile.getContentType()", new Object[]{this.mMediaType, i}).addStatement("param$L = converter.convert(stream, mimeType, param$LType)", new Object[]{i, i}).endControlFlow().beginControlFlow("if (param$L == null)", new Object[]{i}).addStatement("String param$LStr = multiRequest.getParameter($S)", new Object[]{i, name}).beginControlFlow("if (!$T.isEmpty(param$LStr))", new Object[]{this.mTextUtils, i}).addStatement("byte[] data = param$LStr.getBytes()", new Object[]{i}).addStatement("$T stream = new $T(data)", new Object[]{InputStream.class, ByteArrayInputStream.class}).addStatement("$T mimeType = $T.TEXT_PLAIN", new Object[]{this.mMediaType, this.mMediaType}).addStatement("param$L = converter.convert(stream, mimeType, param$LType)", new Object[]{i, i}).endControlFlow().endControlFlow().endControlFlow();
                        if (formPart.required()) {
                            handleCode.beginControlFlow("if (param$L == null)", new Object[]{i}).addStatement("throw new $T($S)", new Object[]{this.mParamMissing, name}).endControlFlow();
                        }
                    }
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "param%d", i));
                    continue;
                }
                RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
                if (requestBody != null) {
                    handleCode.add("\n", new Object[0]);
                    if (this.mString.equals((Object)typeName)) {
                        handleCode.addStatement("String body$L = requestBody.string()", new Object[]{i});
                    } else {
                        ParameterizedTypeName wrapperType = ParameterizedTypeName.get((ClassName)this.mTypeWrapper, (TypeName[])new TypeName[]{typeName});
                        handleCode.addStatement("$T body$L = null", new Object[]{typeName, i}).beginControlFlow("if (converter != null && requestBody != null)", new Object[0]).addStatement("$T body$LType = new $T(){}.getType()", new Object[]{Type.class, i, wrapperType}).addStatement("$T stream = requestBody.stream()", new Object[]{InputStream.class}).addStatement("$T mimeType = requestBody.contentType()", new Object[]{this.mMediaType}).addStatement("body$L = converter.convert(stream, mimeType, body$LType)", new Object[]{i, i}).endControlFlow();
                    }
                    if (requestBody.required()) {
                        handleCode.beginControlFlow("if (body$L == null)", new Object[]{i}).addStatement("throw new $T()", new Object[]{this.mBodyMissing}).endControlFlow();
                    }
                    if (paramBuild.length() > 0) {
                        paramBuild.append(", ");
                    }
                    paramBuild.append(String.format(Locale.getDefault(), "body%d", i));
                    continue;
                }
                throw new IllegalStateException(String.format("The parameter type [%s] is not supported on %s.", typeName, host));
            }
        }
        String executeName = execute.getSimpleName().toString();
        TypeMirror returnMirror = execute.getReturnType();
        boolean isVoid = TypeKind.VOID.equals((Object)returnMirror.getKind());
        if (isVoid) {
            handleCode.addStatement("(($T)mHost).$L($L)", new Object[]{type, executeName, paramBuild.toString()});
        } else {
            handleCode.addStatement("Object o = (($T)mHost).$L($L)", new Object[]{type, executeName, paramBuild.toString()});
        }
        handleCode.addStatement("return new $T($L, $L)", new Object[]{this.mViewObject, isRest, isVoid ? null : "o"});
        MethodSpec handleMethod = MethodSpec.methodBuilder((String)"onHandle").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(this.mView).addParameter(this.mRequest, "request", new Modifier[0]).addParameter(this.mResponse, "response", new Modifier[0]).addException(Throwable.class).addCode(handleCode.build()).build();
        String packageName = this.getPackageName(type).getQualifiedName().toString();
        executeName = StringUtils.capitalize((String)executeName);
        String className = String.format("%s%sHandler%s", type.getSimpleName(), executeName, "");
        int i = 0;
        while (this.mHashCodes.contains(className.hashCode())) {
            className = String.format("%s%sHandler%s", type.getSimpleName(), executeName, ++i);
        }
        this.mHashCodes.add(className.hashCode());
        TypeSpec handlerClass = TypeSpec.classBuilder((String)className).addJavadoc("This file was generated by AndServer automatically and you should NOT edit it.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(this.mMappingHandler).addField(hostField).addMethod(rootMethod).addMethod(handleMethod).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)handlerClass).build();
        try {
            javaFile.writeTo(this.mFiler);
            return className;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBasicType(TypeName typeName) {
        return this.mString.equals((Object)typeName) || TypeName.INT.equals((Object)typeName) || TypeName.LONG.equals((Object)typeName) || TypeName.FLOAT.equals((Object)typeName) || TypeName.DOUBLE.equals((Object)typeName) || TypeName.BOOLEAN.equals((Object)typeName);
    }

    private void createBasicParameter(CodeBlock.Builder builder, TypeName type, String name, int index) {
        TypeName box = type.isBoxedPrimitive() ? type : type.box();
        builder.addStatement("$T $L$L = null", new Object[]{box, name, index});
    }

    private void assignmentBasicParameter(CodeBlock.Builder builder, TypeName type, String name, int index) {
        builder.beginControlFlow("try", new Object[0]);
        TypeName box = type.isBoxedPrimitive() ? type : type.box();
        builder.addStatement("$L$L = $T.valueOf($L$LStr)", new Object[]{name, index, box, name, index});
        builder.nextControlFlow("catch (Throwable e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{this.mParamError}).endControlFlow();
    }

    private boolean isBasicArrayType(TypeName typeName) {
        return this.mStringArray.equals((Object)typeName) || this.mIntArray.equals((Object)typeName) || this.mLongArray.equals((Object)typeName) || this.mFloatArray.equals((Object)typeName) || this.mDoubleArray.equals((Object)typeName) || this.mBooleanArray.equals((Object)typeName);
    }

    private void createBasicArrayParameter(CodeBlock.Builder builder, TypeName type, int index) {
        TypeName component = ((ArrayTypeName)type).componentType;
        builder.addStatement("$T[] param$L = new $T[param$LList.size()]", new Object[]{component, index, component, index});
    }

    private void assignmentBasicArrayParameter(CodeBlock.Builder builder, TypeName type, int index) {
        builder.beginControlFlow("try", new Object[0]);
        TypeName component = ((ArrayTypeName)type).componentType;
        TypeName box = component.isBoxedPrimitive() ? component : component.box();
        builder.beginControlFlow("for(int i = 0; i < param$LList.size(); i++)", new Object[]{index}).addStatement("param$L[i] = $T.valueOf(param$LList.get(i))", new Object[]{index, box, index}).endControlFlow();
        builder.nextControlFlow("catch (Throwable e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{this.mParamError}).endControlFlow();
    }

    private void createRegister(String packageName, Map<String, List<String>> adapterMap) {
        ParameterizedTypeName listTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.mAdapter});
        ParameterizedTypeName typeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.mString, listTypeName});
        FieldSpec mapField = FieldSpec.builder((TypeName)typeName, (String)"mMap", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        CodeBlock.Builder rootCode = CodeBlock.builder().addStatement("this.mMap = new $T<>()", new Object[]{HashMap.class});
        for (Map.Entry<String, List<String>> entry : adapterMap.entrySet()) {
            String group = entry.getKey();
            List<String> adapterList = entry.getValue();
            CodeBlock.Builder groupCode = CodeBlock.builder().addStatement("List<$T> $LList = new $T<>()", new Object[]{this.mAdapter, group, ArrayList.class});
            for (String adapterName : adapterList) {
                ClassName className = ClassName.bestGuess((String)adapterName);
                groupCode.addStatement("$LList.add(new $T())", new Object[]{group, className});
            }
            rootCode.add(groupCode.build());
            rootCode.addStatement("this.mMap.put($S, $LList)", new Object[]{group, group});
        }
        MethodSpec rootMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(rootCode.build()).build();
        MethodSpec registerMethod = MethodSpec.methodBuilder((String)"onRegister").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.mContext, "context", new Modifier[0]).addParameter(this.mString, "group", new Modifier[0]).addParameter(this.mRegisterType, "register", new Modifier[0]).addStatement("List<$T> list = mMap.get(group)", new Object[]{this.mAdapter}).beginControlFlow("if(list == null)", new Object[0]).addStatement("list = new $T<>()", new Object[]{ArrayList.class}).endControlFlow().addStatement("List<$T> defaultList = mMap.get($S)", new Object[]{this.mAdapter, "default"}).beginControlFlow("if(defaultList != null && !defaultList.isEmpty())", new Object[0]).addStatement("list.addAll(defaultList)", new Object[0]).endControlFlow().beginControlFlow("if(list != null && !list.isEmpty())", new Object[0]).beginControlFlow("for ($T adapter : list)", new Object[]{this.mAdapter}).addStatement("register.addAdapter(adapter)", new Object[0]).endControlFlow().endControlFlow().build();
        String className = "AdapterRegister";
        TypeSpec handlerClass = TypeSpec.classBuilder((String)className).addJavadoc("This file was generated by AndServer automatically and you should NOT edit it.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(this.mOnRegisterType).addField(mapField).addMethod(rootMethod).addMethod(registerMethod).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)handlerClass).build();
        try {
            javaFile.writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getGroup(TypeElement type) {
        Controller controller = type.getAnnotation(Controller.class);
        if (controller != null) {
            return controller.value();
        }
        RestController restController = type.getAnnotation(RestController.class);
        if (restController != null) {
            return restController.value();
        }
        throw new IllegalStateException(String.format("The type is not a Controller: %1$s.", type));
    }

    private PackageElement getPackageName(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    @Override
    protected void addAnnotation(Set<Class<? extends Annotation>> classSet) {
        classSet.add(RequestMapping.class);
        classSet.add(GetMapping.class);
        classSet.add(PostMapping.class);
        classSet.add(PutMapping.class);
        classSet.add(PatchMapping.class);
        classSet.add(DeleteMapping.class);
        classSet.add(AppInfo.class);
    }
}

